/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import com.dataiku.dip.shaker.facet.AlphanumFacetWithMap;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class SerializedMemTableV2 {
    public List<Header> headers = new ArrayList<Header>();
    public SerializedTableChunk initialChunk;
    public ColoringDefinition.TableColoringScheme coloringScheme;
    public MemTable.MemTableChange scriptChange;
    public String usedSampleId;
    public long sampleBuildDate;
    public List<FilterFacet> filterFacets = new ArrayList<FilterFacet>();
    public WarningsContext.SerializedWarnings warnings;
    public DataService.ShakerRecipeSchema newRecipeSchema;
    public SerializedShakerScript.DisplayedColumnsSelection newColumnsSelection;
    public List<String> allColumnNames = new ArrayList<String>();
    int totalRows;
    int totalDeletedRows;
    int totalDeletedKeptRows;
    int totalKeptRows;
    int totalEmptyCells;
    int totalFullCells;
    int initialRows;
    int initialCols;
    SampleMetadata sampleMetadata;
    int previewRowsAdded;
    int previewRowsDeleted;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.table");

    public void fill(MemScriptRunner.TableWithReport table, SerializedShakerScript sss, int maxRows, int maxCols) {
        this.coloringScheme = sss.coloring.scheme;
        this.initialRows = table.initialRows;
        this.initialCols = table.initialCols;
        this.previewRowsAdded = table.previewRowsAdded;
        this.previewRowsDeleted = table.previewRowsDeleted;
        this.scriptChange = table.scriptChange;
        this.usedSampleId = table.usedSample == null ? null : table.usedSample.id;
        this.sampleBuildDate = table.usedSample == null ? -1L : table.usedSample.computeTime;
        this.sampleMetadata = table.usedSample == null ? null : table.usedSample.metadata;
        this.filterFacets = table.facets;
        this.warnings = table.warnings;
        this.newRecipeSchema = table.newRecipeSchema;
        this.totalRows = table.table.rows.size();
        if (table.isPreviewMode) {
            int idx = 0;
            for (MemRow mr : table.table.rows) {
                if (mr.isDeleted()) {
                    ++this.totalDeletedRows;
                    if (table.filters == null || table.filters[idx]) {
                        ++this.totalDeletedKeptRows;
                    }
                }
                ++idx;
            }
        }
        this.totalKeptRows = table.filters == null ? this.totalRows : FilteringExecutor.countTrue(table.filters);
        this.newColumnsSelection = new SerializedShakerScript.DisplayedColumnsSelection();
        this.newColumnsSelection.list = new ArrayList<SerializedShakerScript.DisplayedColumn>();
        int returnedCols = 0;
        this.newColumnsSelection.mode = sss.columnsSelection.mode;
        for (Column column : table.table.columns()) {
            SerializedShakerScript.DisplayedColumn newDisplayedColumn = new SerializedShakerScript.DisplayedColumn();
            newDisplayedColumn.name = column.getName();
            newDisplayedColumn.d = true;
            if (sss.columnsSelection.mode == SerializedShakerScript.DisplayedColumnsMode.SELECT) {
                SerializedShakerScript.DisplayedColumn oldDisplayedColumn = sss.columnsSelection.getColumn(column.getName());
                newDisplayedColumn.d = oldDisplayedColumn == null || oldDisplayedColumn.d;
            }
            returnedCols += newDisplayedColumn.d ? 1 : 0;
            this.newColumnsSelection.list.add(newDisplayedColumn);
        }
        this.newColumnsSelection.applyColumnOrder(sss.columnOrder);
        int returnedRows = Math.min(maxRows, table.table.rows.size());
        this.initialChunk = new SerializedTableChunk(0, returnedRows, 0, returnedCols);
        SerializedTableChunk.DisplayOptions options = SerializedTableChunk.DisplayOptions.fromShakerScript(sss).withColumnsSelection(this.newColumnsSelection);
        this.initialChunk.fill(table.table, table.filters, options);
        for (SerializedShakerScript.DisplayedColumn displayedColumn : this.newColumnsSelection.list) {
            this.allColumnNames.add(displayedColumn.name);
            if (sss.columnsSelection.mode != SerializedShakerScript.DisplayedColumnsMode.ALL && !displayedColumn.d) continue;
            MemColumn column = table.table.getColumn(displayedColumn.name);
            assert (column != null);
            Header header = this.computeColumnHeader(sss, table, column);
            this.headers.add(header);
        }
    }

    public void overrideRowCount(int totalRows) {
        this.totalRows = totalRows;
        this.totalKeptRows = totalRows;
    }

    private Header computeColumnHeader(SerializedShakerScript sss, MemScriptRunner.TableWithReport table, MemColumn cd) {
        Header h = new Header();
        h.name = cd.getName();
        for (DataTypeMatch dtm : cd.candidateTypes) {
            MeaningResult dt = new MeaningResult();
            dt.name = dtm.type.getMeaningId();
            dt.nbEmpty = dtm.nbEmpty;
            dt.nbNOK = dtm.nbFails;
            dt.nbOK = dtm.nbParses;
            dt.score = dtm.totalDetectionScore;
            h.possibleTypes.add(dt);
        }
        if (cd.selectedType != null) {
            DataTypeMatch dtm = cd.selectedType;
            MeaningResult dt = new MeaningResult();
            dt.name = dtm.type.getMeaningId();
            dt.nbEmpty = dtm.nbEmpty;
            dt.nbNOK = dtm.nbFails;
            dt.nbOK = dtm.nbParses;
            dt.score = dtm.totalDetectionScore;
            if (dtm.type instanceof Text) {
                h.deletedMeaningName = ((Text)dtm.type).deletedMeaningName;
            }
            h.selectedType = dt;
            h.meaningOrigin = cd.meaningOrigin;
            h.isDouble = cd.selectedType.type.isDouble();
            this.totalEmptyCells += dtm.nbEmpty;
            this.totalFullCells += dtm.nbParses + dtm.nbFails;
        }
        h.distinctValues = cd.distinctValues;
        h.ncharsToShow = cd.ncharsToShow;
        h.recipeSchemaColumn = cd.recipeSchemaColumn;
        h.datasetSchemaColumn = cd.datasetSchemaColumn;
        h.facetForColoring = cd.facetForColoring;
        h.analysisForColoring = cd.analysisForColoring;
        block0 : switch (sss.coloring.scheme) {
            case FILL_ONLY: {
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case INDIVIDUAL_COLUMNS_VALUES: {
                if (sss.coloring.individualColumns.contains(h.name)) {
                    if (h.facetForColoring != null) {
                        h.progressBarType = Header.ProgressBarType.VALUE_COLORING_ANUM;
                        break;
                    }
                    h.progressBarType = Header.ProgressBarType.VALUE_COLORING_NUM;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case ALL_COLUMNS_VALUES: {
                if (h.facetForColoring != null) {
                    h.progressBarType = Header.ProgressBarType.VALUE_COLORING_ANUM;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.VALUE_COLORING_NUM;
                break;
            }
            case MEANING_AND_STATUS: {
                if (table.filters != null) {
                    h.progressBarType = Header.ProgressBarType.MEANING_VALIDITY_MUTED;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.MEANING_VALIDITY;
                break;
            }
            case SINGLE_COLUMN_VALUES: {
                if (h.name.equals(sss.coloring.singleColumn)) {
                    if (h.facetForColoring != null) {
                        h.progressBarType = Header.ProgressBarType.VALUE_COLORING_ANUM;
                        break;
                    }
                    h.progressBarType = Header.ProgressBarType.VALUE_COLORING_NUM;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case SINGLE_VALUE_HIGHLIGHT: {
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case INDIVIDUAL_COLUMNS_RULES: {
                if (sss.coloring.individualColumnsRules.stream().anyMatch(columnRule -> h.name.equals(columnRule.column))) {
                    h.progressBarType = Header.ProgressBarType.RULE_COLORING;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case SINGLE_COLUMN_RULES: {
                if (h.name.equals(sss.coloring.singleColumn) && sss.coloring.individualColumnsRules.stream().anyMatch(columnRule -> h.name.equals(columnRule.column))) {
                    h.progressBarType = Header.ProgressBarType.RULE_COLORING;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
            case COLORING_GROUPS: {
                ColoringDefinition.ColoringGroup coloringGroup = ColoringDefinition.findAppliedColoringGroup(sss.coloring.coloringGroups, (String)cd.getName());
                if (coloringGroup != null && coloringGroup.scheme != null && coloringGroup.isBasedOnTargetedColumn(cd.getName())) {
                    switch (coloringGroup.scheme) {
                        case MEANING_AND_STATUS: {
                            h.progressBarType = Header.ProgressBarType.MEANING_VALIDITY;
                            break block0;
                        }
                        case COLOR_SCALE: {
                            if (h.facetForColoring != null) {
                                h.progressBarType = Header.ProgressBarType.VALUE_COLORING_ANUM;
                                break block0;
                            }
                            h.progressBarType = Header.ProgressBarType.VALUE_COLORING_NUM;
                            break block0;
                        }
                        case RULES: {
                            boolean hasSomeAssociatedRules = false;
                            if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.COLUMNS || coloringGroup.scope == ColoringDefinition.ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN) {
                                boolean bl = hasSomeAssociatedRules = !coloringGroup.rulesGroup.filterDescs.isEmpty();
                            }
                            if (hasSomeAssociatedRules) {
                                h.progressBarType = Header.ProgressBarType.RULE_COLORING;
                                break block0;
                            }
                            h.progressBarType = Header.ProgressBarType.NONE;
                            break block0;
                        }
                    }
                    h.progressBarType = Header.ProgressBarType.NONE;
                    break;
                }
                h.progressBarType = Header.ProgressBarType.NONE;
                break;
            }
        }
        h.progressBarChunks = cd.progressBarChunks;
        return h;
    }

    public static class Header {
        public String name;
        public String state;
        public MeaningResult selectedType;
        public MemColumn.MeaningOrigin meaningOrigin;
        public List<MeaningResult> possibleTypes = new ArrayList<MeaningResult>();
        public boolean isDouble;
        public int distinctValues;
        public int ncharsToShow;
        @Nullable
        String deletedMeaningName;
        public AlphanumFacetWithMap facetForColoring;
        public NumericalVariableAnalysis analysisForColoring;
        public ProgressBarType progressBarType;
        public List<ProgressBarChunk> progressBarChunks;
        public DataService.ShakerRecipeSchemaColumn recipeSchemaColumn;
        public SchemaColumn datasetSchemaColumn;

        public static class ProgressBarChunk {
            public String cls;
            public String value;
            public double lower;
            public double upper;
            public double ratio;

            public ProgressBarChunk() {
            }

            public ProgressBarChunk(String cls, String value, double ratio) {
                this.cls = cls;
                this.value = value;
                this.ratio = ratio;
            }

            public ProgressBarChunk(String cls, double lower, double upper, double ratio) {
                this.cls = cls;
                this.lower = lower;
                this.upper = upper;
                this.ratio = ratio;
            }

            public ProgressBarChunk(String cls, double ratio) {
                this.cls = cls;
                this.ratio = ratio;
            }
        }

        public static enum ProgressBarType {
            MEANING_VALIDITY,
            MEANING_VALIDITY_MUTED,
            NONE,
            VALUE_COLORING_ANUM,
            VALUE_COLORING_NUM,
            RULE_COLORING;

        }
    }

    public static class MeaningResult {
        public String name;
        public int nbEmpty;
        public int nbOK;
        public int nbNOK;
        public double score;
    }
}

