/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnValue;
import com.dataiku.dip.shaker.sql.AbstractSqlFilterAndFlagOnSimpleCriteria;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class SqlFilterAndFlagOnValue
extends AbstractSqlFilterAndFlagOnSimpleCriteria {
    public SqlFilterAndFlagOnValue(SQLQueryWithSchema chain, FilterAndFlagOnValue.Parameter parameter) {
        super(chain, parameter);
    }

    @Override
    protected ExpressionBuilder exprFor(String column) {
        Type columnType;
        Preconditions.checkArgument((this.chain.getCurrentColumn(column) != null ? 1 : 0) != 0, (Object)("No schema column found for column " + column));
        ExpressionBuilder comparableCol = this.chain.col(column);
        SchemaColumn schemaColumn = this.chain.getCurrentColumn(column);
        comparableCol.expr.outputType.dssType = columnType = schemaColumn.getType();
        List<Object> values = this.convertToNativeType(columnType, this.getTypedParameter().values);
        boolean useNativeType = values.size() == this.getTypedParameter().values.size();
        boolean isString = columnType == Type.STRING;
        boolean shouldCastValue = false;
        if (!(isString || useNativeType && this.getTypedParameter().matchingMode != StringMatchingMode.SUBSTRING)) {
            isString = true;
            comparableCol = comparableCol.castToString(100);
            shouldCastValue = this.chain.getDialect().requiresStrictTypeComparison();
        }
        ArrayList<ExpressionBuilder> valueExprs = new ArrayList<ExpressionBuilder>();
        int idx = -1;
        Iterator<String> iterator = this.getTypedParameter().values.iterator();
        while (iterator.hasNext()) {
            ExpressionBuilder constant;
            String value;
            String comparableValue = value = iterator.next();
            ++idx;
            switch (this.getTypedParameter().normalizationMode) {
                case EXACT: {
                    break;
                }
                case LOWERCASE: {
                    if (!isString) break;
                    comparableCol = comparableCol.lower();
                    comparableValue = comparableValue.toLowerCase(Locale.ENGLISH);
                    break;
                }
                case NORMALIZED: {
                    throw new Error("Unreachable");
                }
            }
            if (!isString && columnType == Type.BOOLEAN) {
                java.lang.Boolean b = (java.lang.Boolean)values.get(idx);
                valueExprs.add(comparableCol.isnotnull().and(b != false ? comparableCol.isTrue() : comparableCol.isFalse()));
                continue;
            }
            Type forcedType = isString ? Type.STRING : null;
            ExpressionBuilder expressionBuilder = constant = !isString ? this.ebf.cst(values.get(idx)) : this.ebf.cst((Object)comparableValue, forcedType);
            if (shouldCastValue) {
                constant = constant.castToString(100);
            }
            switch (this.getTypedParameter().matchingMode) {
                case FULL_STRING: {
                    ExpressionBuilder expressionBuilder2 = comparableCol.eq(constant);
                    if (columnType.isTimestamp() && this.chain.getDialect().shouldForceFormatForDateComparison()) {
                        expressionBuilder2 = expressionBuilder2.or(this.chain.col(column).format(Type.DATE, "yyyy-MM-dd HH:mm:ss").eq(constant));
                    } else if (columnType == Type.DATEONLY && this.chain.getDialect().shouldForceFormatForDateOnlyComparison()) {
                        expressionBuilder2 = expressionBuilder2.or(this.chain.col(column).format(Type.DATEONLY, "yyyy-MM-dd").eq(constant));
                    }
                    valueExprs.add(comparableCol.isnotnull().and(expressionBuilder2));
                    break;
                }
                case SUBSTRING: {
                    valueExprs.add(comparableCol.isnotnull().and(comparableCol.contains(constant)));
                    break;
                }
                case PATTERN: {
                    throw new Error("Unreachable");
                }
            }
        }
        Preconditions.checkArgument((!valueExprs.isEmpty() ? 1 : 0) != 0, (Object)"No value to flag rows on.");
        ExpressionBuilder colExpr = (ExpressionBuilder)valueExprs.get(0);
        for (int i = 1; i < valueExprs.size(); ++i) {
            colExpr = colExpr.or((ExpressionBuilder)valueExprs.get(i));
        }
        return colExpr;
    }

    private List<Object> convertToNativeType(Type t, List<String> values) {
        ArrayList<Object> converted = new ArrayList<Object>();
        boolean stayAsString = DKUApp.getParams().getBoolParam("dku.FilterAndFlagOnValue.keepDatetimeAsString", false);
        block16: for (String s : values) {
            if (s == null) continue;
            switch (t) {
                case BOOLEAN: {
                    java.lang.Boolean b = new Boolean().parseNoFail(s);
                    if (b == null) continue block16;
                    converted.add(b);
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case BIGINT: 
                case INT: {
                    long l = new LongMeaning().longValue(s);
                    if (l == Long.MAX_VALUE) continue block16;
                    converted.add(l);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    double d = new DoubleMeaning().doubleValue(s);
                    if (Double.isNaN(d)) continue block16;
                    converted.add(d);
                    break;
                }
                case DATE: {
                    DateTime date2;
                    try {
                        date2 = QuerySQLWriter.isoFormatter.parseDateTime(s);
                        converted.add(date2);
                    }
                    catch (IllegalArgumentException date2) {}
                    break;
                }
                case DATETIMENOTZ: {
                    DateTime date2;
                    if (stayAsString) break;
                    try {
                        date2 = QuerySQLWriter.sqlFormatter.parseLocalDateTime(s);
                        converted.add(date2);
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            date2 = QuerySQLWriter.sqlFormatterMilli.parseLocalDateTime(s);
                            converted.add(date2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    break;
                }
                case DATEONLY: {
                    DateTime date2;
                    if (stayAsString) break;
                    try {
                        date2 = QuerySQLWriter.sqlDateFormatter.parseLocalDate(s);
                        converted.add(date2);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return converted;
    }

    private FilterAndFlagOnValue.Parameter getTypedParameter() {
        return (FilterAndFlagOnValue.Parameter)this.getTypedParams();
    }
}

