/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SparkConfigurator {
    private static Boolean sparkAvailabilityBaseCache;
    private static final Logger logger;

    private static boolean checkSparkAvailabilityBase() {
        return true;
    }

    public static synchronized boolean sparkAvailableBase() throws IOException {
        if (sparkAvailabilityBaseCache == null) {
            sparkAvailabilityBaseCache = SparkConfigurator.checkSparkAvailabilityBase();
        }
        return sparkAvailabilityBaseCache;
    }

    public static boolean interactiveSparkSQLAvailable(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        return SparkConfigurator.interactiveSparkSQLExecutionEngine(authCtx, projectKey) != null;
    }

    public static AbstractSparkRecipeParams.SparkExecutionEngine interactiveSparkSQLExecutionEngine(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        if (!SparkConfigurator.sparkAvailableBase()) {
            return null;
        }
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        if (sparkSettings == null || !sparkSettings.sparkEnabled) {
            return null;
        }
        return sparkSettings.interactiveExecutionEngine;
    }

    public static String interactiveSparkSQLSparkVersion(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        if (!SparkConfigurator.sparkAvailableBase()) {
            return "";
        }
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
        if (sparkSettings == null || !sparkSettings.sparkEnabled) {
            return "";
        }
        return SparkSubmitHelper.getSparkVersion(sparkSettings);
    }

    public static SparkConnection configureConnectionForDatabase(String databaseName, List<SimpleKeyValue> sparkconf, SparkSQLConnectionPoolService connectionPoolService) throws IOException, DKUSecurityException {
        String virtualName = "@virtual(spark-livy):" + databaseName;
        SparkConnection conn = new SparkConnection(connectionPoolService);
        conn.name = virtualName;
        conn.allowWrite = false;
        conn.allowManagedDatasets = false;
        conn.params.db = databaseName;
        if (sparkconf != null) {
            conn.params.sparkconf.addAll(sparkconf);
        }
        return conn;
    }

    static void setupFromSettings(SparkConnection.Params connParams, SparkSettings sparkSettings) {
        connParams.fetchSize = 1000;
        connParams.yarnClusterSettings = sparkSettings.yarnClusterSettings;
        connParams.yarnCluster = true;
    }

    static {
        logger = Logger.getLogger(SparkConfigurator.class);
    }
}

