/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.DSSJobKernelMain;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.DSSFutureKernelMain;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.logging.SparkLoggingConfigurator;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkConfigEnricher;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobBuilder;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLConnection;
import com.dataiku.dip.spark.sparksql.SparkSubmitSparkSQLHandler;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.spark.yarnaware.YarnClusterCacheDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.LoggableCommand;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SparkSQLConnectionPoolService {
    private static final AtomicInteger nextConnectionId = new AtomicInteger();
    private final KeyedPoolableObjectFactory<SparkSQLConnectionKey, SparkSQLConnectionWrapper> connectionFactory = new BaseKeyedPoolableObjectFactory<SparkSQLConnectionKey, SparkSQLConnectionWrapper>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SparkSQLConnectionWrapper makeObject(SparkSQLConnectionKey key) throws Exception {
            logger.info((Object)("Creating a new SparkLivy connection (db=" + key.getDatabase() + ")"));
            ClusterSelector clusterSelector = new ClusterSelector();
            ClusterSettings clusterSettings = StringUtils.isNotBlank((String)key.getClusterId()) ? clusterSelector.selectForCluster(key.getAuthCtx(), key.getClusterId(), key.getK8sClusterId()) : clusterSelector.selectGlobal();
            SparkSettings sparkSettings = clusterSettings.getSparkSettings();
            HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
            if (sparkSettings.interactiveExecutionEngine == null) {
                throw new IllegalStateException("Interactive SparkSQL is not activated");
            }
            SparkExecutionConfig interactiveExecutionConfig = sparkSettings.getByName(StringUtils.defaultIfBlank((String)sparkSettings.configForInteractive, (String)"default"));
            List<SimpleKeyValue> conf = SparkJobHelper.composeConf(key.getAuthCtx(), "__DKU_ANY_PROJECT__", sparkSettings, interactiveExecutionConfig, key.getSparkconf());
            UserImpersonationTarget impersonationTarget = key.getImpersonationTarget();
            switch (sparkSettings.interactiveExecutionEngine) {
                case SPARK_SUBMIT: {
                    AutoDelete sparkSubmitRunDir = FlowJobUtils.getTmpFolder("spark-submit", "out");
                    logger.info((Object)("Setup files for sparksql notebook in " + sparkSubmitRunDir.getAbsolutePath()));
                    try (SparkBasedActivityHelper helper = new SparkBasedActivityHelper("__DKU_ANY_PROJECT__", key.authCtx, (File)sparkSubmitRunDir, impersonationTarget);){
                        SparkSQLConnectionWrapper sparkSQLConnectionWrapper;
                        helper.configure(new HashSet<String>(), key.getSparkconf(), clusterSettings);
                        helper.setCloudCredentialsConfKeys(interactiveExecutionConfig);
                        new SparkConfigEnricher().setMetastoreConfKeysInAdditionalSparkConf(interactiveExecutionConfig, helper.getJobExecEnv());
                        ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forPooledSparkSQLConnection((AuthCtx)key.getAuthCtx());
                        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                        try {
                            sparkSQLConnectionWrapper = this.createSparkSubmit(key, sparkSettings, hadoopSettings, conf, helper, interactiveExecutionConfig);
                        }
                        catch (Throwable throwable) {
                            CurrentComputeResourceUsageContext.clear();
                            throw throwable;
                        }
                        CurrentComputeResourceUsageContext.clear();
                        return sparkSQLConnectionWrapper;
                    }
                }
            }
            throw new Error("Unsupported execution engine: " + String.valueOf((Object)sparkSettings.interactiveExecutionEngine));
        }

        private SparkSQLConnectionWrapper createSparkSubmit(SparkSQLConnectionKey key, SparkSettings sparkSettings, HadoopSettings hadoopSettings, List<SimpleKeyValue> conf, SparkBasedActivityHelper helper, SparkExecutionConfig executionConfig) throws Exception {
            SparkConnection sparkConnection = SparkConfigurator.configureConnectionForDatabase(key.getDatabase(), conf, SparkSQLConnectionPoolService.this);
            sparkConnection.params.clusterId = key.getClusterId();
            sparkConnection.hadoopSettings = hadoopSettings;
            sparkConnection.sparkSettings = sparkSettings;
            SparkConfigurator.setupFromSettings(sparkConnection.params, sparkSettings);
            APITicketService.Ticket ticket = SparkSQLConnectionPoolService.this.acquireTicketForSpark(key);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            ResponderKernelLink serverSocket = new ResponderKernelLink(ticket.getSecret(), dssPortRange);
            final int socketPort = serverSocket.getPort();
            logger.info((Object)("Started a socket on port " + socketPort));
            EnvironmentStash stash = new EnvironmentStash();
            stash.fillDefault();
            stash.env.putAll(helper.getProcessExtraEnv());
            stash.apiTicket = ticket.getSecret();
            if (RemoteRunNetworkingUtils.getServerKind() == MainLoggingConfigurator.ProcessType.JEK) {
                AbstractCodeBasedActivityRunner.FlowSpec spec = new AbstractCodeBasedActivityRunner.FlowSpec();
                spec.tintercomAPIBase = "kernel/tintercom";
                spec.jekHost = DSSJobKernelMain.getKernelHost();
                spec.jekPort = DSSJobKernelMain.getKernelPort();
                spec.currentActivityId = JobContext.getCurrentActivity();
                stash.flowSpec = spec;
            } else if (ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CDE) {
                throw new UnsupportedOperationException("SparkSQL is not available from containerized jobs");
            }
            SparkJobBuilder jobBuilder = new SparkJobBuilder(){

                @Override
                public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                    return helper.makeClassJob("DSS notebook (SQL)", false, effectiveConf, "com.dataiku.dip.spark.notebook.InteractiveSparkSQLEntryPoint", Integer.toString(socketPort));
                }
            };
            ComputeResourceUsage cru = new ComputeResourceUsage();
            SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build("__DKU_ANY_PROJECT__", key.getAuthCtx(), sparkSettings, hadoopSettings, key.getImpersonationTarget(), executionConfig);
            sparkSubmitHelper.setK8SClusterId(key.k8sClusterId);
            sparkSubmitHelper.setComputeResourceUsage(cru);
            SparkSubmitJob job = jobBuilder.buildSparkJob(sparkSubmitHelper, helper.getProcessRunDir(), sparkSettings, conf);
            for (AbstractSQLConnection.CustomDatabaseProperty kv : sparkConnection.params.properties) {
                job.conf.add(new SimpleKeyValue(kv.name, kv.value));
            }
            for (File file : SparkLoggingConfigurator.copyConfigurationFilesToRunDir(helper.getProcessRunDir())) {
                job.nonSecretGlobalFiles.add(file.getAbsolutePath());
            }
            SparkJobHelper.SparkJobContext context = sparkSubmitHelper.runsInClusterMode(job) ? sparkSubmitHelper.setupRunUsingCluster(SparkJobHelper.RunMode.SPARK, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), null) : sparkSubmitHelper.setupRunUsingClient(SparkJobHelper.RunMode.SPARK, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), null);
            cru.reportStartNoFail();
            LoggableCommand cmd = sparkSubmitHelper.toCommand(job);
            logger.info((Object)("Execute spark-submit:\n" + cmd.getLogString()));
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(helper.getProcessRunDir());
            builder.environment().putAll(stash.getAsEnvVariables(true, true, false));
            builder.command(cmd.getCommands());
            try {
                SparkSubmitSparkSQLHandler sparkSQLHandler = new SparkSubmitSparkSQLHandler(key.getAuthCtx(), builder, serverSocket, context, "__DKU_ANY_PROJECT__", key.getImpersonationTarget());
                DkuSparkSQLConnection conn = new DkuSparkSQLConnection(sparkSQLHandler, sparkConnection.params.db, sparkConnection.params.fetchSize);
                SparkSQLConnectionWrapper wrapper = new SparkSQLConnectionWrapper(sparkConnection, conn, nextConnectionId.getAndIncrement(), ticket, cru);
                logger.info((Object)("Created SparkLivy connection id=" + wrapper.connectionId));
                return wrapper;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create Livy batch", (Throwable)e);
                SparkSQLConnectionPoolService.this.releaseTicket(ticket);
                try {
                    serverSocket.close();
                }
                catch (Exception e2) {
                    logger.error((Object)"Failed to close socket", (Throwable)e2);
                }
                try {
                    context.close();
                }
                catch (Exception e2) {
                    logger.error((Object)"Failed to close yarn-cluster context", (Throwable)e2);
                }
                throw e;
            }
        }

        public void activateObject(SparkSQLConnectionKey key, SparkSQLConnectionWrapper connection) throws Exception {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Activate SparkLivy connection id=" + connection.connectionId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(SparkSQLConnectionKey key, SparkSQLConnectionWrapper connection) throws Exception {
            logger.debug((Object)("Destroy SparkLivy connection id=" + connection.connectionId));
            Exception caught = null;
            try {
                connection.connection.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close connection", (Throwable)e);
                caught = e;
            }
            finally {
                SparkSQLConnectionPoolService.this.releaseTicket(connection.ticket);
                if (connection.cru != null) {
                    connection.cru.reportCompleteNoFail();
                }
            }
            if (caught != null) {
                throw caught;
            }
        }

        public void passivateObject(SparkSQLConnectionKey key, SparkSQLConnectionWrapper connection) throws Exception {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Passivate SparkLivy connection id=" + connection.connectionId));
            }
        }

        public boolean validateObject(SparkSQLConnectionKey key, SparkSQLConnectionWrapper connection) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Validate SparkLivy connection id=" + connection.connectionId));
            }
            try {
                connection.connection.checkHealth();
                return true;
            }
            catch (SQLException e) {
                logger.warn((Object)("SparkLivy connection id=" + connection.connectionId + " is not functional anymore, dropping it"), (Throwable)e);
                return false;
            }
        }
    };
    private GenericKeyedObjectPool<SparkSQLConnectionKey, SparkSQLConnectionWrapper> connectionsPool;
    private int changeVersion = 0;
    private long generalSettingsLastModified = 0L;
    private Map<String, Integer> clusterChangeVersion = Maps.newHashMap();
    private Map<String, Long> clusterLastModified = Maps.newHashMap();
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IImpersonationResolverService impersonationService;
    @Autowired
    private YarnClusterCacheDAO yarnClusterCacheDAO;
    private static final Logger logger = Logger.getLogger((String)"dku.spark.livy.pool");

    private APITicketService.Ticket acquireTicketForSpark(SparkSQLConnectionKey key) throws IOException {
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        if (RemoteRunNetworkingUtils.getServerKind() == MainLoggingConfigurator.ProcessType.FEK) {
            APITicketService.Ticket kernelTicket = apiTicketService.getSingleTicket();
            try (LocalBackendPrivilegedIntercomAPIClient apiClient = new LocalBackendPrivilegedIntercomAPIClient();){
                String apiTicket = (String)apiClient.postFormToJSON("/dip/api/pintercom/futures/acquire-api-ticket", String.class, new Object[]{"kernelAPITicket", kernelTicket.getSecret(), "kernelId", DSSFutureKernelMain.id, "description", "SparkSQL Livy notebook"});
                APITicketService.Ticket ticket = new APITicketService.Ticket().withUser(kernelTicket.getOriginalUser()).withSecret(apiTicket);
                return ticket;
            }
        }
        return apiTicketService.createTicket(key.authCtx, "SparkSQL Livy notebook", (Object)key);
    }

    private void releaseTicket(APITicketService.Ticket ticket) throws IOException {
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        if (RemoteRunNetworkingUtils.getServerKind() == MainLoggingConfigurator.ProcessType.FEK) {
            APITicketService.Ticket kernelTicket = apiTicketService.getSingleTicket();
            try (LocalBackendPrivilegedIntercomAPIClient apiClient = new LocalBackendPrivilegedIntercomAPIClient();){
                apiClient.postFormToJSON("/dip/api/pintercom/futures/release-api-ticket", Void.class, new Object[]{"kernelAPITicket", kernelTicket.getSecret(), "apiTicket", ticket.getSecret()});
            }
        } else {
            apiTicketService.expireTicket(ticket);
        }
    }

    @PostConstruct
    private void startPool() {
        Params p = ApplicationConfigurator.getParams();
        String prefix = "dku.spark.sparkSQLConnectionsPool";
        this.connectionsPool = new GenericKeyedObjectPool(this.connectionFactory);
        this.connectionsPool.setLifo(false);
        this.connectionsPool.setTestOnBorrow(true);
        this.connectionsPool.setTestOnReturn(true);
        this.connectionsPool.setTestWhileIdle(true);
        this.connectionsPool.setMinEvictableIdleTimeMillis((long)p.getIntParam(prefix + ".connectionEvictTimeMS", Integer.valueOf(600000)));
        this.connectionsPool.setTimeBetweenEvictionRunsMillis((long)p.getIntParam(prefix + ".connectionEvictRunIntervalMS", Integer.valueOf(120000)));
        this.connectionsPool.setWhenExhaustedAction((byte)2);
    }

    private int getConfigurationChangeVersion() throws IOException {
        long lastModified;
        if (TransactionContext.hasAttachedTransaction()) {
            lastModified = this.generalSettingsDAO.getLastModified();
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                lastModified = this.generalSettingsDAO.getLastModified();
            }
        }
        if (this.generalSettingsLastModified != 0L && this.generalSettingsLastModified != lastModified) {
            ++this.changeVersion;
            logger.info((Object)"Configuration change, clearing the connections pool");
            this.connectionsPool.clear();
        }
        this.generalSettingsLastModified = lastModified;
        return this.changeVersion;
    }

    private int getClusterConfigurationChangeVersion(String clusterId) throws IOException {
        long lastModified;
        Integer changeVersion = this.clusterChangeVersion.get(clusterId);
        if (changeVersion == null) {
            changeVersion = 0;
        }
        if (TransactionContext.hasAttachedTransaction()) {
            lastModified = this.clustersDAO.getLastModifiedOrZero(clusterId);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                lastModified = this.clustersDAO.getLastModifiedOrZero(clusterId);
            }
        }
        if (this.clusterLastModified.containsKey(clusterId) && this.clusterLastModified.get(clusterId) != lastModified) {
            changeVersion = changeVersion + 1;
        }
        this.clusterChangeVersion.put(clusterId, changeVersion);
        this.clusterLastModified.put(clusterId, lastModified);
        return changeVersion;
    }

    public SparkSQLConnection take(String clusterId, String k8sClusterId, AuthCtx authCtx, String database, List<SimpleKeyValue> sparkconf, String projectKey) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Acquire SparkLivy connection active=" + this.connectionsPool.getNumActive() + " idle=" + this.connectionsPool.getNumIdle() + " changeVersion=" + this.changeVersion));
        }
        try {
            UserImpersonationTarget impersonationTarget;
            int currentChangeVersion = this.getConfigurationChangeVersion();
            int currentClusterChangeVersion = this.getClusterConfigurationChangeVersion(clusterId);
            if (this.impersonationService.isEnabled()) {
                try {
                    impersonationTarget = this.impersonationService.getTargetUser(projectKey, authCtx);
                }
                catch (DKUSecurityException e) {
                    throw new SQLException("Impersonation denied", e);
                }
            } else {
                impersonationTarget = new UserImpersonationTarget(System.getProperty("user.name"), SparkJobHelper.safeGetLoginShortUserName());
            }
            SparkSQLConnectionKey key = new SparkSQLConnectionKey(clusterId, k8sClusterId, authCtx, impersonationTarget, database, sparkconf, currentChangeVersion, currentClusterChangeVersion);
            logger.info((Object)("take key " + String.valueOf(key) + " active=" + this.connectionsPool.getNumActive((Object)key) + " idle=" + this.connectionsPool.getNumIdle((Object)key)));
            SparkSQLConnectionWrapper wrapper = (SparkSQLConnectionWrapper)this.connectionsPool.borrowObject((Object)key);
            String debugId = key.toString() + "-" + SecretKeyGenerator.generateSmall();
            return new SparkSQLConnection(wrapper, key, this, debugId, true);
        }
        catch (IllegalStateException e) {
            throw new Exception("Pool should not be closed", e);
        }
        catch (NoSuchElementException e) {
            throw new Exception("Pool should not be empty", e);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedSQLException(SparkCodes.ERR_SPARK_LIVY_CONNECTION_FAILED, "Could not create SparkLivy connection", (Throwable)e);
        }
    }

    public void give(SparkSQLConnectionWrapper connection, SparkSQLConnectionKey key) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Return SparkLivy connection id=" + connection.connectionId));
        }
        logger.info((Object)("give key " + String.valueOf(key)));
        try {
            int currentChangeVersion = this.getConfigurationChangeVersion();
            int currentClusterChangeVersion = this.getClusterConfigurationChangeVersion(key.getClusterId());
            if (key.getChangeVersion() != currentChangeVersion) {
                logger.info((Object)"Configuration change happened, invalidating it");
                this.connectionsPool.invalidateObject((Object)key, (Object)connection);
            } else if (key.getClusterChangeVersion() != currentClusterChangeVersion) {
                logger.info((Object)"Cluster configuration change happened, invalidating it");
                this.connectionsPool.invalidateObject((Object)key, (Object)connection);
            } else {
                this.connectionsPool.returnObject((Object)key, (Object)connection);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to return a connection", (Throwable)e);
        }
    }

    public static class SparkSQLConnectionKey {
        private final AuthCtx authCtx;
        private final String database;
        private final String clusterId;
        private final String k8sClusterId;
        private final String authCtxStr;
        private final int changeVersion;
        private final int clusterChangeVersion;
        private final List<SimpleKeyValue> sparkconf;
        private final UserImpersonationTarget impersonationTarget;

        public SparkSQLConnectionKey(String clusterId, String k8sClusterId, AuthCtx authCtx, UserImpersonationTarget impersonationTarget, String database, List<SimpleKeyValue> sparkconf, int changeVersion, int clusterChangeVersion) {
            this.clusterId = clusterId;
            this.k8sClusterId = k8sClusterId;
            this.authCtx = authCtx;
            this.impersonationTarget = impersonationTarget;
            this.clusterChangeVersion = clusterChangeVersion;
            this.sparkconf = sparkconf != null ? sparkconf : new ArrayList();
            this.changeVersion = changeVersion;
            this.authCtxStr = authCtx.toString();
            this.database = database;
        }

        public int getChangeVersion() {
            return this.changeVersion;
        }

        public int getClusterChangeVersion() {
            return this.clusterChangeVersion;
        }

        public AuthCtx getAuthCtx() {
            return this.authCtx;
        }

        public UserImpersonationTarget getImpersonationTarget() {
            return this.impersonationTarget;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public String getK8sClusterId() {
            return this.k8sClusterId;
        }

        public List<SimpleKeyValue> getSparkconf() {
            return this.sparkconf;
        }

        public String toString() {
            return "<Key: authCtx=" + this.authCtxStr + " impersonationTarget=" + String.valueOf(this.impersonationTarget) + " clusterId=" + StringUtils.defaultIfBlank((String)this.clusterId, (String)"") + " k8sClusterId=" + StringUtils.defaultIfBlank((String)this.k8sClusterId, (String)"") + " db=" + this.database + " sparkConf=" + JSON.json(this.sparkconf) + "/>";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.authCtxStr.hashCode();
            result = 31 * result + (StringUtils.isBlank((String)this.clusterId) ? 0 : this.clusterId.hashCode());
            result = 31 * result + (StringUtils.isBlank((String)this.k8sClusterId) ? 0 : this.k8sClusterId.hashCode());
            result = 31 * result + (this.impersonationTarget == null ? 0 : this.impersonationTarget.hashCode());
            result = 31 * result + (StringUtils.isBlank((String)this.database) ? 0 : this.database.hashCode());
            result = 31 * result + this.sparkconf.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SparkSQLConnectionKey other = (SparkSQLConnectionKey)obj;
            if (!this.authCtxStr.equals(other.authCtxStr)) {
                return false;
            }
            if (!StringUtils.equals((String)this.clusterId, (String)other.clusterId)) {
                return false;
            }
            if (!StringUtils.equals((String)this.k8sClusterId, (String)other.k8sClusterId)) {
                return false;
            }
            if (!Objects.equals(this.impersonationTarget, other.impersonationTarget)) {
                return false;
            }
            if (!StringUtils.equals((String)this.database, (String)other.database)) {
                return false;
            }
            return this.sparkconf.equals(other.sparkconf);
        }
    }

    static class SparkSQLConnectionWrapper {
        public final DkuSparkSQLConnection connection;
        public final int connectionId;
        public final APITicketService.Ticket ticket;
        private final SparkConnection sparkConnection;
        final ComputeResourceUsage cru;

        SparkSQLConnectionWrapper(SparkConnection sparkConnection, DkuSparkSQLConnection connection, int connectionId, APITicketService.Ticket ticket, ComputeResourceUsage cru) {
            this.connection = connection;
            this.connectionId = connectionId;
            this.ticket = ticket;
            this.sparkConnection = sparkConnection;
            this.cru = cru;
        }
    }

    public static class SparkSQLConnection
    extends SQLConnectionProvider.SQLConnectionWrapper {
        public final SparkSQLConnectionKey key;
        private final SparkSQLConnectionPoolService service;
        private final SparkSQLConnectionWrapper wrapper;
        private boolean isClosed = false;

        private SparkSQLConnection(SparkSQLConnectionWrapper wrapper, SparkSQLConnectionKey key, SparkSQLConnectionPoolService service, String debugId, boolean verboseRollback) {
            super(wrapper.sparkConnection.getConnectionData_NT(key.authCtx, null), wrapper.connection, debugId, verboseRollback);
            this.wrapper = wrapper;
            this.key = key;
            this.service = service;
        }

        public DkuSparkSQLConnection getLivyConnection() {
            return this.wrapper.connection;
        }

        public SparkConnection getSparkConnection() {
            return this.wrapper.sparkConnection;
        }

        @Override
        public ComputeResourceUsage getComputeResourceUsage() {
            return this.wrapper.cru;
        }

        @Override
        public void rollbackAndClose() {
            try {
                logger.info((Object)("Closing " + String.valueOf(this)));
                this.close();
                logger.info((Object)("Conn " + String.valueOf(this) + " is now " + this.isClosed()));
            }
            catch (Exception e) {
                logger.warn((Object)("Could not safely close SQL connection " + String.valueOf(this)), (Throwable)e);
            }
        }

        @Override
        public void close() throws SQLException {
            if (!this.isClosed) {
                this.isClosed = true;
                this.service.give(this.wrapper, this.key);
                this.cru.reportCompleteNoFail();
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.isClosed;
        }
    }
}

