/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SchemaReader;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import javax.annotation.Nullable;

public class BigQueryUtils {
    public static void checkPartitioningConsistency(AuthCtx authCtx, AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config, @Nullable PartitioningScheme partitioningScheme) throws CodedException, DKUSecurityException, IOException, SQLException {
        if (BigQueryUtils.shouldCheckPartitioningConsistency(connection, config) && BigQueryUtils.hasPartitioningConsistencyMismatch(authCtx, connection, config, partitioningScheme)) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Connection settings forbid writing to a BigQuery table if there is a partitioning configuration mismatch between the dataset and the table");
        }
    }

    public static boolean hasPartitioningConsistencyMismatch(AuthCtx authCtx, AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config, @Nullable PartitioningScheme partitioningScheme) throws DKUSecurityException, IOException, SQLException {
        if (partitioningScheme == null || !partitioningScheme.isPartitioned()) {
            return false;
        }
        SQLDialect dialect = connection.getDialect();
        SchemaReader.TablePartitionInfo tablePartitionInfo = dialect.retrieveTablePartitionInfo(authCtx, connection, config.catalog, config.schema, config.table);
        return BigQueryUtils.hasPartitioningConsistencyMismatch(tablePartitionInfo, partitioningScheme);
    }

    public static boolean hasPartitioningConsistencyMismatch(SchemaReader.TablePartitionInfo tablePartitionInfo, @Nullable PartitioningScheme partitioningScheme) {
        if (partitioningScheme == null || !partitioningScheme.isPartitioned()) {
            return false;
        }
        if (tablePartitionInfo.dimension == null) {
            return true;
        }
        String firstDimensionName = (String)partitioningScheme.getDimensionNames().get(0);
        if (!firstDimensionName.equals(tablePartitionInfo.dimension.getName())) {
            return true;
        }
        Dimension firstDimension = partitioningScheme.getDimension(firstDimensionName);
        if (tablePartitionInfo.dimension instanceof ExactValueDimension && firstDimension instanceof ExactValueDimension) {
            return false;
        }
        return !tablePartitionInfo.dimension.equals((Object)firstDimension);
    }

    private static boolean shouldCheckPartitioningConsistency(AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config) {
        AbstractSQLConnection.AbstractSQLParams abstractSQLParams = connection.getParams();
        if (abstractSQLParams instanceof BigQueryConnection.Params) {
            BigQueryConnection.Params connectionParams = (BigQueryConnection.Params)abstractSQLParams;
            if (config instanceof BigQueryDatasetConfig) {
                BigQueryDatasetConfig bigQueryDatasetConfig = (BigQueryDatasetConfig)config;
                return bigQueryDatasetConfig.forbidPartitionsWriteToNonPartitionedTable.isEnabled() || bigQueryDatasetConfig.forbidPartitionsWriteToNonPartitionedTable.isInherited() && connectionParams.forbidPartitionsWriteToNonPartitionedTable;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean partitionSchemeMatches(Dataset dataset, SchemaReader.TablePartitionInfo bigQueryPartitionInfo) {
        boolean assumedTZIsUTC;
        PartitioningScheme partitionScheme = dataset.getPartitioningSchema();
        BigQueryDatasetConfig params = dataset.getParamsAs(BigQueryDatasetConfig.class);
        if (!partitionScheme.isSingleDimension()) {
            return false;
        }
        if (bigQueryPartitionInfo == null) return false;
        if (bigQueryPartitionInfo.dimension == null) {
            return false;
        }
        Dimension dssDimension = partitionScheme.getSingleDimension();
        Dimension bqDimension = bigQueryPartitionInfo.dimension;
        if (dssDimension.getName() == null) return false;
        if (!dssDimension.getName().equals(bqDimension.getName())) {
            return false;
        }
        if (bqDimension instanceof ExactValueDimension) {
            ExactValueDimension evd = (ExactValueDimension)bqDimension;
            if (!(dssDimension instanceof ExactValueDimension)) return false;
            if (evd.integerRangeInfo == null) return false;
            if (evd.integerRangeInfo.interval() != 1L) return false;
            return true;
        }
        if (!(bqDimension instanceof TimeDimension)) return false;
        TimeDimension bqTimeDimension = (TimeDimension)bqDimension;
        String originalSQLType = dataset.getSchema().getColumn((String)dssDimension.getName()).originalSQLType;
        String assumedTZId = params.getAssumedJavaTzForUnknownTz();
        ZoneRules zoneRules = ZoneId.of(assumedTZId).getRules();
        boolean bl = assumedTZIsUTC = zoneRules.isFixedOffset() && zoneRules.getOffset(Instant.EPOCH).equals(ZoneOffset.UTC);
        if (!assumedTZIsUTC) {
            if ("DATETIME".equals(originalSQLType)) {
                if (params.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) return false;
            }
            if ("DATE".equals(originalSQLType) && params.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                return false;
            }
        }
        boolean bl2 = false;
        boolean timezonesInconsistent = bl2;
        if (timezonesInconsistent) return false;
        if (!(dssDimension instanceof TimeDimension)) return false;
        TimeDimension dssTimeDimension = (TimeDimension)dssDimension;
        if (bqTimeDimension.mappedPeriod != dssTimeDimension.mappedPeriod) return false;
        return true;
    }
}

