/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.sql.LoadedJavaDialect;
import java.util.HashMap;
import java.util.Map;

public class CustomSQLDialectsRegistry {
    private static Map<String, LoadedJavaDialect> dialects = new HashMap<String, LoadedJavaDialect>();

    private CustomSQLDialectsRegistry() {
    }

    public static void register(LoadedJavaDialect dialect) {
        dialects.put(dialect.getType(), dialect);
    }

    public static void deregister(String dialectType) {
        dialects.remove(dialectType);
    }

    public static LoadedJavaDialect getDialect(String dialectType) {
        if (!dialects.containsKey(dialectType)) {
            throw new IllegalArgumentException("Dialect " + dialectType + " is not loaded.");
        }
        return dialects.get(dialectType);
    }

    public static boolean hasDialect(String dialectType) {
        return dialects.containsKey(dialectType);
    }
}

