/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.utils.ExceptionUtils;
import java.sql.DatabaseMetaData;

public class DriverVersionExtractor {
    private final DatabaseMetaData meta;
    private SQLConnectionProvider.SQLConnectionWrapper.DriverVersion version;

    public DriverVersionExtractor(DatabaseMetaData meta) {
        this.meta = meta;
    }

    private void ensureVersionDefined() {
        if (this.version != null) {
            return;
        }
        try {
            this.version = new SQLConnectionProvider.SQLConnectionWrapper.DriverVersion(this.meta.getDriverVersion(), this.meta.getDriverMajorVersion(), this.meta.getDriverMinorVersion());
        }
        catch (Throwable e) {
            this.version = new SQLConnectionProvider.SQLConnectionWrapper.DriverVersion("Unknown database version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")", -1, -1);
        }
    }

    public SQLConnectionProvider.SQLConnectionWrapper.DriverVersion getVersion() {
        this.ensureVersionDefined();
        return this.version;
    }

    public String getFormatterDriverInfos() {
        return String.format("Driver: %s (%s) %s", this.getFormattedDriverName(), this.getFormattedJDBCVersion(), this.getFormattedDriverVersion());
    }

    public String getFormattedDatabaseInfos() {
        return String.format("Database: %s %s %s %s", this.getFormattedDatabaseName(), this.getFormattedDatabaseVersion(), this.getFormattedMaxRowSize(), this.getFormattedMaxStatements());
    }

    private String getFormattedDriverName() {
        try {
            return this.meta.getDriverName();
        }
        catch (Throwable e) {
            return "Unknown driver (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedDriverVersion() {
        this.ensureVersionDefined();
        return String.format("%s (%s.%s)", this.version.version, this.version.majorVersion, this.version.minorVersion);
    }

    private String getFormattedJDBCVersion() {
        try {
            int major = this.meta.getJDBCMajorVersion();
            int minor = this.meta.getJDBCMinorVersion();
            return String.format("JDBC %s.%s", major, minor);
        }
        catch (Throwable e) {
            return "Unknown JDBC version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedDatabaseName() {
        try {
            return this.meta.getDatabaseProductName();
        }
        catch (Throwable e) {
            return "Unknown database (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedMaxRowSize() {
        try {
            return String.format("rowSize=%s", this.meta.getMaxRowSize());
        }
        catch (Throwable e) {
            return "rowSize=N/A";
        }
    }

    private String getFormattedMaxStatements() {
        try {
            return String.format("stmts=%s", this.meta.getMaxStatements());
        }
        catch (Throwable e) {
            return "stmts=N/A";
        }
    }

    private String getFormattedDatabaseVersion() {
        try {
            String version = this.meta.getDatabaseProductVersion();
            int major = this.meta.getDatabaseMajorVersion();
            int minor = this.meta.getDatabaseMinorVersion();
            return String.format("%s (%s.%s)", version, major, minor);
        }
        catch (Throwable e) {
            return "Unknown database version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }
}

