/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.datasets.sql.mysql.MySQLDatasetConfig;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.SQLCommentService;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.RowSizeLimiter;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class MySQLDialect
extends GenericSQLDialect {
    private static String TIMESTAMP_DECL_FOR_TABLES = "timestamp null";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.mysql");
    private final String numericRegex = "^-?([0-9]+(\\\\.[0-9]*)?|\\\\.[0-9]+)([eE][-+]?[0-9]+)?$";

    @Override
    protected boolean canWriteInfinityOrNaN() {
        return false;
    }

    @Override
    public boolean supportsCaseInsensitivityRegExp() {
        return true;
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        String defaultQuery = super.generateTableStatementSQL(connection, dataset, messages, ifNotExist);
        StringBuilder sb = new StringBuilder(defaultQuery);
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if (config.hasWriteDatasetDescriptionAsSQLCommentEnabled(connection) && dataset.getModel().description != null) {
            sb.append(String.format("\n  COMMENT=%s", this.quoteString(this.truncateDescription(dataset.getModel().description, dataset.getName(), true, messages))));
        }
        sb.append(" CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        return sb.toString();
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                SchemaColumn ret = new SchemaColumn(name, Type.STRING);
                if (sqlPrecision > 0 && sqlPrecision < Integer.MAX_VALUE) {
                    ret.maxLength = sqlPrecision;
                }
                return ret;
            }
            case -1: {
                return new SchemaColumn(name, Type.STRING);
            }
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        Type type = schemaColumn.getType();
        switch (type) {
            case DATE: {
                String dateOutputType = TIMESTAMP_DECL_FOR_TABLES;
                if (dataset != null) {
                    assert (dataset.getParams() instanceof MySQLDatasetConfig);
                    if (((MySQLDatasetConfig)dataset.getParams()).useDatetimeForDates) {
                        dateOutputType = "datetime";
                    }
                }
                return new DSSTypeSQLMapping(Type.DATE, 93, dateOutputType, new Integer[]{91});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "datetime", new Integer[]{91});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public String getIdentifierQuoteChar() {
        return "`";
    }

    @Override
    public String quoteDate(String str) {
        return "CONVERT_TZ(" + this.quoteString(str) + ",'GMT',@@session.time_zone)";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATE)";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATETIME)";
    }

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String captureGroup(int group) {
        return "$" + group;
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "DAY(" + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "HOUR(" + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "MINUTE(" + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "SECOND(" + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(MICROSECOND(" + inputDateExpression + ")/1000)";
            }
            case MONTH_OF_YEAR: {
                return "MONTH(" + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "WEEK(" + inputDateExpression + ",3)";
            }
            case QUARTER_OF_YEAR: {
                return "QUARTER(" + inputDateExpression + ")";
            }
            case YEAR: {
                return "CAST(YEAR(" + inputDateExpression + ") AS SIGNED INTEGER)";
            }
            case DAY_OF_WEEK: {
                return "((DAYOFWEEK(" + inputDateExpression + ")+5)%7+1)";
            }
            case SECOND_FROM_EPOCH: {
                return "UNIX_TIMESTAMP(" + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(UNIX_TIMESTAMP(" + inputDateExpression + ") * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on MySQL", part));
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return "CAST(" + this.dateTruncInternal(inputDateExpression, rounding) + " AS DATE)";
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return "CAST(" + this.dateTruncInternal(inputDateExpression, rounding) + " AS DATETIME)";
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return "CONVERT_TZ(" + this.dateTruncInternal(inputDateExpression, rounding) + ",'GMT',@@session.time_zone)";
    }

    public String dateTruncInternal(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-%m-%d 00:00:00')";
            }
            case HOUR: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-%m-%d %k:00:00')";
            }
            case MINUTE: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-%m-%d %k:%i:00')";
            }
            case SECOND: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-%m-%d %k:%i:%s')";
            }
            case MONTH: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-%m-01 00:00:00')";
            }
            case WEEK: {
                return this.dateTruncInternal("DATE_SUB(" + inputDateExpression + ", INTERVAL ((DAYOFWEEK(" + inputDateExpression + ")+5)%7) DAY)", DateRounding.DAY);
            }
            case YEAR: {
                return "DATE_FORMAT(" + inputDateExpression + ", '%Y-01-01 00:00:00')";
            }
            case QUARTER: {
                return "CONCAT(" + this.datePartExpression(inputDateExpression, DatePart.YEAR) + ",'-',(CEIL(" + this.datePartExpression(inputDateExpression, DatePart.MONTH_OF_YEAR) + "/3)-1)*3+1,'-01 00:00:00')";
            }
        }
        throw new UnsupportedOperation("Date truncation " + String.valueOf(rounding) + " is not implemented for MySQL");
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIME_ZONE = '+00:00'";
    }

    @Override
    public boolean hasCaseInsensitiveColumns() {
        return true;
    }

    @Override
    public boolean isSchemaAware() {
        return false;
    }

    @Override
    public boolean canSQL99() {
        return false;
    }

    @Override
    public boolean supportsCTEs() {
        return false;
    }

    @Override
    public String convertStringToNumber(String inputExpr) {
        return "(0.0 + (" + inputExpr + "))";
    }

    @Override
    @Deprecated
    public String convertToVarchar(String inputExpr, int len) {
        return "CAST((" + inputExpr + ") AS CHAR(" + len + "))";
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        Object ret = expr;
        String sqlType = this.getSQLType((Type)requestedType, (int)maxLength, (String)ret).sqlDecl.toUpperCase();
        if (sqlType.contains("INT")) {
            sqlType = "SIGNED INTEGER";
        } else {
            if (requestedType == Type.FLOAT || requestedType == Type.DOUBLE) {
                return "(0.0 + (" + expr + "))";
            }
            if (requestedType == Type.DATE && (exprType == null || exprType == Type.STRING)) {
                return "FROM_UNIXTIME(UNIX_TIMESTAMP(REPLACE(CAST((" + expr + ") AS CHAR(100)), 'Z', '')))";
            }
            if (requestedType == Type.BOOLEAN) {
                if (exprType == Type.STRING) {
                    return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS CHAR(100)) = '' THEN NULL ELSE LOWER(CAST(" + expr + " AS CHAR(100))) RLIKE '^" + this.booleanTrueValuesRegex + "$' END";
                }
                return "(" + expr + " != 0)";
            }
            if (sqlType.startsWith("VARCHAR")) {
                sqlType = sqlType.replaceAll("VARCHAR", "CHAR");
            } else if (TIMESTAMP_DECL_FOR_TABLES.equalsIgnoreCase(sqlType) || "timestamp".equalsIgnoreCase(sqlType)) {
                return "TIMESTAMP(" + (String)ret + ")";
            }
        }
        ret = "CAST(" + (String)ret + " AS " + sqlType + ")";
        return ret;
    }

    @VisibleForTesting
    static int computeMaxColumnLength(String column, List<SchemaColumn> indexColumns, int currentSize) {
        boolean currentColumnIsStringAndPartOfIndex = false;
        int numberOfStringColumnsInIndex = 0;
        for (SchemaColumn indexColumn : indexColumns) {
            if (indexColumn.getType() != Type.STRING) continue;
            ++numberOfStringColumnsInIndex;
            if (!column.equalsIgnoreCase(indexColumn.getName())) continue;
            currentColumnIsStringAndPartOfIndex = true;
        }
        int maxIndexSize = 3072;
        int sizeOfStringColumnInIndex = numberOfStringColumnsInIndex == 0 ? currentSize : (maxIndexSize - (indexColumns.size() - numberOfStringColumnsInIndex) * 8) / (4 * numberOfStringColumnsInIndex);
        return currentColumnIsStringAndPartOfIndex ? Math.min(currentSize, sizeOfStringColumnInIndex) : currentSize;
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> indexColumns, InfoMessage.InfoMessages messages) {
        RowSizeLimiter limiter = new RowSizeLimiter("MySQL", DatasetCodes.WARN_DATASET_MYSQL_SCHEMA_TOO_LARGE, 65000, 4, false){

            @Override
            protected int computeMaxColumnLength(String columnName, List<SchemaColumn> indexColumns, int sizePerField) {
                return MySQLDialect.computeMaxColumnLength(columnName, indexColumns, sizePerField);
            }
        };
        limiter.setDefaultLengthForSchemaColumn(schema, indexColumns, messages);
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 16000;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public String getLimitedQuery(String query, long size, long offset) {
        return this.getLimitedQueryUsingLimit(query, size, offset);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.LENGTH, "CHAR_LENGTH", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA256, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "SHA2(" + column + ", 256)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SHA512, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "SHA2(" + column + ", 512)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RAND, "RAND", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 0 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) throws QueryUtils.SQLGenerationException {
                this.validateNumberOfParameters(args);
                if (args == null || args.length == 0) {
                    return "RAND()";
                }
                if (args.length == 2) {
                    String min = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS SIGNED)";
                    String max = "CAST(" + this.toSQLNoBrackets(args[1]) + " AS SIGNED)";
                    return String.format("%1$s + CAST(FLOOR(RAND() * (%2$s - %1$s)) AS SIGNED)", min, max);
                }
                return super.apply(args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": {
                        return "(CAST(YEAR(" + end + ") AS SIGNED INTEGER) - CAST(YEAR(" + start + ") AS SIGNED INTEGER) - case when " + end + ">" + start + " then (DATE_FORMAT(" + end + ", '%m%d') < DATE_FORMAT(" + start + ", '%m%d')) else -(DATE_FORMAT(" + end + ", '%m%d') > DATE_FORMAT(" + start + ", '%m%d')) end)";
                    }
                    case "MONTH": {
                        return "(PERIOD_DIFF(DATE_FORMAT(" + end + ", '%Y%m'), DATE_FORMAT(" + start + ", '%Y%m')) - case when " + end + ">" + start + " then (DATE_FORMAT(" + end + ", '%d%H%i%s') < DATE_FORMAT(" + start + ", '%d%H%i%s')) else -(DATE_FORMAT(" + end + ", '%d%H%i%s') > DATE_FORMAT(" + start + ", '%d%H%i%s')) end)";
                    }
                    case "WEEK": {
                        return "TRUNCATE((DATEDIFF(" + end + ", " + start + ") - case when " + end + ">" + start + " then (DATE_FORMAT(" + end + ", '%H%i%s') < DATE_FORMAT(" + start + ", '%H%i%s')) else -(DATE_FORMAT(" + end + ", '%H%i%s') > DATE_FORMAT(" + start + ", '%H%i%s')) end)/7,0)";
                    }
                    case "DAY": {
                        return "TRUNCATE(DATEDIFF(" + end + ", " + start + ") - case when " + end + ">" + start + " then (DATE_FORMAT(" + end + ", '%H%i%s') < DATE_FORMAT(" + start + ", '%H%i%s')) else -(DATE_FORMAT(" + end + ", '%H%i%s') > DATE_FORMAT(" + start + ", '%H%i%s')) end,0)";
                    }
                    case "HOUR": {
                        return "TIMESTAMPDIFF(HOUR," + start + ", " + end + ")";
                    }
                    case "MINUTE": {
                        return "TIMESTAMPDIFF(MINUTE," + start + ", " + end + ")";
                    }
                    case "SECOND": {
                        return "TIMESTAMPDIFF(SECOND," + start + ", " + end + ")";
                    }
                }
                throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2 && args[2] != null) {
                    return "CONVERT_TZ( " + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[2]) + ", " + this.toSQLNoBrackets(args[1]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "CONVERT_TZ( " + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + ", @@session.time_zone)";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return "CONVERT_TZ(" + ret + ",'GMT',@@session.time_zone)";
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS DATETIME)"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "group_concat", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                String column = this.toSQLNoBrackets(args[0]);
                String separator = null;
                boolean distinct = false;
                if (args.length > 1) {
                    QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                    String string = separator = separatorExpr == null ? null : this.toSQLNoBrackets(separatorExpr);
                }
                if (args.length > 2) {
                    QueryAst.ConstExpr distinctExpr = (QueryAst.ConstExpr)args[2];
                    boolean bl = distinct = distinctExpr == null ? false : (Boolean)distinctExpr.value;
                }
                if (separator == null) {
                    return "group_concat(" + (distinct ? "DISTINCT " : "") + " CAST(" + column + " AS CHAR) separator '')";
                }
                return "group_concat(" + (distinct ? "DISTINCT " : "") + " CAST(" + column + " AS CHAR) separator " + separator + ")";
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, false, true, "|"));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, false, true, "|"));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, false, true, "|"));
        this.removeOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG);
        this.removeOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_WIN);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Object intervalValue = addIntLong;
                String validUnit = unit;
                if ("MILLISECOND".equals(unit)) {
                    validUnit = "SECOND";
                    intervalValue = addIntLong + "/1000";
                }
                return "(" + datetimeNoTz + " + INTERVAL " + (String)intervalValue + " " + validUnit + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SWITCH_WHEN, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String parameterCase;
                String parameterFormat;
                this.validateMinNumberOfParameters(args, 3);
                int numberOfParameters = args.length;
                String expressionToMatch = this.toSQLNoBrackets(args[0]);
                if (expressionToMatch.equalsIgnoreCase("'true'")) {
                    parameterFormat = "CAST(%s AS UNSIGNED)";
                    parameterCase = "1";
                } else if (expressionToMatch.equalsIgnoreCase("'false'")) {
                    parameterFormat = "CAST(%s AS UNSIGNED)";
                    parameterCase = "0";
                } else {
                    parameterFormat = "%s";
                    parameterCase = expressionToMatch;
                }
                StringBuilder caseWhenThen = new StringBuilder();
                caseWhenThen.append("CASE ").append(parameterCase);
                for (int parameterIndex = 1; parameterIndex < numberOfParameters - 1; parameterIndex += 2) {
                    caseWhenThen.append(" WHEN ").append(String.format(parameterFormat, this.toSQLNoBrackets(args[parameterIndex]))).append(" THEN ").append(this.toSQLNoBrackets(args[parameterIndex + 1]));
                }
                if (numberOfParameters % 2 == 0) {
                    caseWhenThen.append(" ELSE ").append(this.toSQLNoBrackets(args[numberOfParameters - 1]));
                }
                return caseWhenThen.append(" END").toString();
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "(" + input + ") RLIKE (" + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = MySQLDialect.this.toDateFormat(jodaFormat, true);
                    String converted = "STR_TO_DATE(" + input + ",'" + sqlFormat + "')";
                    if (requestedType == Type.DATEONLY) {
                        return converted;
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "CAST(" + converted + " AS DATETIME)";
                    }
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return "TIMESTAMP(" + converted + ")";
                    }
                    return "CONVERT_TZ(" + converted + ", '" + timezoneId + "', 'UTC')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = MySQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType.isTimestamp() && StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "CONVERT_TZ(" + (String)input + ", 'UTC', '" + timezoneId + "')";
                    }
                    return "DATE_FORMAT(" + (String)input + ", '" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return MySQLDialect.this.generateRegExpReplace(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return MySQLDialect.this.generateRegExpSubstr(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST, "CAST", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Type currentType = MySQLDialect.this.getExpressionTypeIfFixed(args[0]);
                if (args.length == 1 || args[1] == null) {
                    throw new QueryUtils.SQLGenerationException("No type specified for cast.");
                }
                Type requestedType = this.getCastTargetType(args[1]);
                String ret = this.toSQLNoBrackets(args[0]);
                if (currentType == null || currentType != requestedType) {
                    int maxLength = -1;
                    if (args.length > 2) {
                        maxLength = this.getParamAs(args[2], Integer.class);
                    }
                    if (!this.doesNotNeedCast(args[0], requestedType, maxLength)) {
                        ret = MySQLDialect.this.cast(ret, currentType, requestedType, maxLength);
                    }
                }
                return ret;
            }

            private boolean doesNotNeedCast(QueryAst.Expr expression, Type requestedType, int maxLength) {
                if (requestedType == Type.STRING && expression instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)expression).value instanceof String) {
                    return ((String)((QueryAst.ConstExpr)expression).value).length() < maxLength || maxLength < 0;
                }
                return false;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_SUM, "SUM", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                boolean isMultipleArgument = false;
                if (args.length > 1 && args[1] instanceof QueryAst.InlineExpr) {
                    String value = ((QueryAst.InlineExpr)args[1]).expr;
                    isMultipleArgument = Boolean.parseBoolean(value);
                }
                Object query = "CASE\n";
                if (!isMultipleArgument) {
                    query = (String)query + "    WHEN JSON_VALID({0}) AND JSON_TYPE(CAST({0} AS JSON)) = ''ARRAY'' THEN (\n      SELECT COALESCE(SUM(COALESCE(CAST(array_values.value AS DOUBLE),0)),0)\n      FROM JSON_TABLE(CAST({0} AS JSON), \"$[*]\" COLUMNS(value VARCHAR(32) PATH \"$\")) AS array_values\n      WHERE array_values.value REGEXP ''^-?([0-9]+(\\\\.[0-9]*)?|\\\\.[0-9]+)([eE][-+]?[0-9]+)?$''\n    )\n";
                }
                query = (String)query + "    WHEN {0} REGEXP ''^-?([0-9]+(\\\\.[0-9]*)?|\\\\.[0-9]+)([eE][-+]?[0-9]+)?$'' THEN\n      COALESCE(CAST({0} AS DOUBLE),0)\n    ELSE 0\n  END";
                return MessageFormat.format((String)query, column);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_COUNT, "COUNT", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                Object query = "CASE\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "    WHEN JSON_VALID({0}) AND JSON_TYPE(CAST({0} AS JSON)) = ''ARRAY'' THEN (\n      SELECT COALESCE(SUM(IF(CAST(array_values.value AS DOUBLE) IS NULL, 0, 1)),0)\n      FROM JSON_TABLE(CAST({0} AS JSON), \"$[*]\" COLUMNS(value VARCHAR(32) PATH \"$\")) AS array_values\n      WHERE array_values.value REGEXP ''^-?([0-9]+(\\\\.[0-9]*)?|\\\\.[0-9]+)([eE][-+]?[0-9]+)?$''\n    )\n";
                }
                query = (String)query + "    WHEN {0} REGEXP ''^-?([0-9]+(\\\\.[0-9]*)?|\\\\.[0-9]+)([eE][-+]?[0-9]+)?$'' THEN\n      1\n    ELSE 0\n  END";
                return MessageFormat.format((String)query, column);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "LOWER(HEX(", "))"));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(INSTR(binary ", ", COALESCE(", ", '')) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHAR", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                for (int i = 0; i < from.length() && i < to.length(); ++i) {
                    QueryAst.Expr[] operatorArgs = new QueryAst.Expr[]{new QueryAst.InlineExpr(ret), new QueryAst.ConstExpr(from.substring(i, i + 1)), new QueryAst.ConstExpr(to.substring(i, i + 1))};
                    ret = MySQLDialect.this.getOperator(QueryUtils.OperatorType.REPLACE).apply(operatorArgs);
                }
                return ret;
            }
        });
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 93: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx);
                    if (ts == null) {
                        return null;
                    }
                    long tsTime = ts.getTime();
                    return DKUtils.isoFormatReadableByDateFormat((long)tsTime);
                }
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
            case -4: {
                return null;
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setTimestamp(colIdx, new Timestamp(timestamp));
                break;
            }
            case DATETIMENOTZ: {
                long timestamp = this.typeDatetimeNoTz.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setTimestamp(colIdx, new Timestamp(timestamp));
                break;
            }
            case DATEONLY: {
                long timestamp = this.typeDateOnly.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setDate(colIdx, new Date(timestamp));
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.SharpSingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.BackslashEscapedSingleQuotedFinder.META, QuotedPortionFinders.BackslashEscapedDoubleQuotedFinder.META, QuotedPortionFinders.BackTickedNoEscapeFinder.META};
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return sqlTypeName.equalsIgnoreCase("datetime") && sqlPrecision != 26;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 63;
    }

    @Override
    public boolean isNaturalJoinImplicitlyInner() {
        return true;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case YEAR: 
            case YEAROFERA: {
                return part.shortened ? "%y" : "%Y";
            }
            case WEEKYEAR: {
                return "%x";
            }
            case MONTH: {
                if (part.numeric && part.text.length() == 1) {
                    return "%c";
                }
                if (part.numeric && part.text.length() == 2) {
                    return "%m";
                }
                if (part.shortened) {
                    return "%b";
                }
                return "%M";
            }
            case DAY: {
                if (part.text.length() == 1) {
                    return "%e";
                }
                return "%d";
            }
            case DAYOFYEAR: {
                return "%j";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    throw new IllegalArgumentException("Cannot return monday-based day of week number");
                }
                if (part.shortened) {
                    return "%a";
                }
                return "%W";
            }
            case WEEK: {
                return "%v";
            }
            case HOUR: {
                if (part.text.length() == 1) {
                    return "%k";
                }
                return "%H";
            }
            case HALFDAY: {
                return "%p";
            }
            case HOUROFHALFDAY: {
                if (part.text.length() == 1) {
                    return "%l";
                }
                return "%h";
            }
            case MINUTE: {
                return "%i";
            }
            case SECOND: {
                return "%s";
            }
            case MILLISECOND: {
                return "%f";
            }
            case TIMEZONE: {
                throw new IllegalArgumentException("No timezone in Mysql formats");
            }
            case TEXT: {
                return part.text.replace("%", "%%");
            }
        }
        return part.text;
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE) {
            return SQLCapability.nok("Mysql doesn't have timezone formatting");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && part.numeric) {
            return SQLCapability.nok("Mysql doesn't format to monday-based day of week");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR && part.shortened) {
            return SQLCapability.nok("Mysql doesn't support Week Year with 2 digits");
        }
        return SQLCapability.ok();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            SQLCapability capability = this.canFormatDatePart(part, forParsing);
            if (capability.capable) continue;
            return capability;
        }
        if (forParsing) {
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.WEEK, DKUDateUtils.FormatPatternPartType.DAYOFWEEK, DKUDateUtils.FormatPatternPartType.WEEKYEAR})) {
                return SQLCapability.ok();
            }
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.DAY, DKUDateUtils.FormatPatternPartType.MONTH}) && jodaPattern.hasAny(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.YEAR, DKUDateUtils.FormatPatternPartType.YEAROFERA})) {
                return SQLCapability.ok();
            }
            if (jodaPattern.hasAll(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.DAYOFYEAR}) && jodaPattern.hasAny(new DKUDateUtils.FormatPatternPartType[]{DKUDateUtils.FormatPatternPartType.YEAR, DKUDateUtils.FormatPatternPartType.YEAROFERA})) {
                return SQLCapability.ok();
            }
            return SQLCapability.nok("Format doesn't define the day unambiguously. One of {dayOfWeek, week, weekYear}, {day, month, year} or {dayOfYear, year} is needed");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getId() {
        return "MySQL";
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT table_schema, table_name FROM information_schema.VIEWS WHERE table_name LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "table_schema", " AND table_schema not in ('sys', 'information_schema', 'mysql', 'performance_schema')");
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLDialect.UpsertWriter(){

            @Override
            public String generate(SQLDialect.UpsertSpec spec) {
                List upsertKeys = spec.keys.stream().collect(Collectors.toList());
                if (spec.scheme != null && spec.scheme.isPartitioned()) {
                    upsertKeys.addAll(spec.scheme.getDimensionNames());
                }
                String sourceAlias = MySQLDialect.this.quoteIdentifier("src");
                List targetFields = spec.columns.stream().map(c2 -> MySQLDialect.this.quoteIdentifier((String)c2)).collect(Collectors.toList());
                ArrayList<String> setCommands = new ArrayList<String>();
                for (String c3 : spec.columns) {
                    setCommands.add(String.format("%s = %s.%s", MySQLDialect.this.quoteIdentifier(c3), sourceAlias, MySQLDialect.this.quoteIdentifier(c3)));
                }
                if (!spec.sourceSelect.startsWith("SELECT")) {
                    spec.sourceSelect = String.format("SELECT %s FROM %s", targetFields.stream().collect(Collectors.joining(", ")), spec.sourceSelect);
                }
                return String.format("INSERT INTO %s (%s)\n%s %s\nON DUPLICATE KEY UPDATE %s", MySQLDialect.this.getQuotedTableFullName(spec.target), targetFields.stream().collect(Collectors.joining(", ")), spec.sourceSelect, sourceAlias, setCommands.stream().collect(Collectors.joining(", ")));
            }

            @Override
            public boolean usesIndex() {
                return true;
            }

            @Override
            public boolean canUpsertConcurrently() {
                return false;
            }
        };
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateJoinUpdateSelectWriter(this, true);
    }

    @Override
    public SQLDialect.UniqueConstraintWriter getUniqueConstraintWriter() {
        return new SQLDialect.UniqueConstraintWriter(){

            @Override
            public String generateCreate(SQLDialect.UpsertSpec spec) {
                List upsertKeys = spec.keys.stream().collect(Collectors.toList());
                if (spec.scheme != null && spec.scheme.isPartitioned()) {
                    upsertKeys.addAll(spec.scheme.getDimensionNames());
                }
                List targetKeys = upsertKeys.stream().map(k -> String.format("%s", MySQLDialect.this.quoteIdentifier((String)k))).collect(Collectors.toList());
                return String.format("CREATE UNIQUE INDEX %s ON %s (%s)", MySQLDialect.this.getQuotedTableFullName(spec.index), MySQLDialect.this.getQuotedTableFullName(spec.target), targetKeys.stream().collect(Collectors.joining(", ")));
            }

            @Override
            public String generateDrop(SQLDialect.UpsertSpec spec) {
                return String.format("DROP INDEX %s ON %s", MySQLDialect.this.getQuotedTableFullName(spec.index), MySQLDialect.this.getQuotedTableFullName(spec.target));
            }
        };
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, false);
    }

    @Override
    public boolean canInsertAndSelectConcurrently() {
        return false;
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        return "ALTER TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " COMMENT = " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages));
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public boolean supportsCommentsInCreateTableStatement() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getCreateTableSqlStatement(SQLConnectionProvider.SQLConnectionWrapper conn, String quotedTableFullName) {
        try {
            Statement statement = conn.createStatement();
            try (ResultSet rs2 = statement.executeQuery("SHOW CREATE TABLE " + quotedTableFullName);){
                if (rs2.next()) {
                    String string = rs2.getString("Create Table");
                    return string;
                }
                logger.warn((Object)("Unable to retrieve create table statement for table" + quotedTableFullName));
                return null;
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to retrieve create table statement for table" + quotedTableFullName));
        }
        return null;
    }

    @VisibleForTesting
    static String getColumnDefinition(String createTableSql, String columnName) {
        if (createTableSql == null || StringUtils.isBlank((String)columnName)) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\((.*)\\)", 32);
        Matcher matcher = pattern.matcher(createTableSql);
        if (matcher.find()) {
            String[] definitions;
            String columnSection = matcher.group(1).trim();
            for (String columnDefinition : definitions = columnSection.split(",\\n")) {
                String regex;
                String lowercaseColDef = (columnDefinition = columnDefinition.trim()).toLowerCase();
                if (!lowercaseColDef.matches(regex = "^[`\"]?" + Pattern.quote(columnName.toLowerCase()) + "[`\"]?\\s+.*")) continue;
                return columnDefinition;
            }
        }
        return null;
    }

    @Override
    public void tryWriteColumnComments(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseObjectKey tableKey, List<SchemaColumn> columns, String projectKey, boolean skipEmptyComments, InfoMessage.InfoMessages messages) {
        if (skipEmptyComments) {
            columns = this.removeColumnsWithBlankComments(columns);
        }
        if (columns.size() > 2) {
            try {
                SchemaReader.SchemaWithInfo schemaWithInfo = SchemaReader.getTableSchemaWithInfoAndComments(authCtx, conn, conn.getMetaData(), tableKey.getCatalog(), tableKey.getSchema(), tableKey.getName(), AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, null);
                columns = SQLCommentService.getColumnsWithEditedComments(schemaWithInfo.schema.getColumns(), columns);
                logger.infoV("tryWriteColumnComments: Optimizing query by only updating %d edited columns", new Object[]{columns.size()});
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "tryWriteColumnComments: Error while retrieving schema", new Object[0]);
            }
        }
        if (columns.isEmpty()) {
            return;
        }
        String createTableSQLStatement = MySQLDialect.getCreateTableSqlStatement(conn, this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name));
        logger.info((Object)"tryWriteColumnComments: Executing queries in a batch");
        this.executeAddCommentsToColumnsQueryInBatch(conn, tableKey, createTableSQLStatement, columns, messages);
    }

    private void executeAddCommentsToColumnsQueryInBatch(SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseObjectKey tableKey, String createTableSQLStatement, List<SchemaColumn> columns, InfoMessage.InfoMessages messages) {
        try {
            Statement statement = conn.createStatement();
            int queryCount = 0;
            for (SchemaColumn column : columns) {
                String columnDefinition = MySQLDialect.getColumnDefinition(createTableSQLStatement, column.getName());
                if (columnDefinition != null) {
                    String sql = "ALTER TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " MODIFY COLUMN " + columnDefinition + " COMMENT " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages));
                    statement.addBatch(sql);
                }
                ++queryCount;
            }
            statement.executeBatch();
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
            logger.infoV("tryWriteColumnComments: batch executed with success, columns updated: %d", new Object[]{queryCount});
        }
        catch (SQLException e) {
            logger.warn((Object)"Add SQL comment statement failed", (Throwable)e);
            if (this.supportsCommitAndRollback()) {
                try {
                    conn.rollback();
                }
                catch (Exception rollbackException) {
                    logger.warn((Object)"Error during rollback", (Throwable)rollbackException);
                }
            }
            for (SQLException cur = e; cur != null; cur = cur.getNextException()) {
                messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, (String)ExceptionUtils.getMessageWithCauses((Throwable)cur)));
            }
        }
    }

    @Override
    public boolean hasAccessToAliasInOrderByCaseStatement() {
        return true;
    }

    @Override
    protected List<String> getTableTypesWithoutOverrides(SQLDialect.GetTableTypesReason reason) {
        return Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW", "SYSTEM TABLE"});
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return 2048;
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return 1024;
    }
}

