/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreasureDataSQLDialect
extends TrinoSQLDialect {
    private static final Pattern ARRAY_REGEX = Pattern.compile("^array\\((.*)\\)$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.treasuredata");

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 2003) {
            try {
                return TreasureDataSQLDialect.createSchemaColumnFromSQLTypeName(name, sqlTypeName);
            }
            catch (IllegalArgumentException e) {
                logger.warnV((Throwable)e, "Cannot create schema column for array column: %s defaulting to string.", new Object[]{sqlTypeName});
                return new SchemaColumn(name, Type.STRING);
            }
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case DATE: 
            case DATEONLY: 
            case DATETIMENOTZ: 
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar", new Integer[0]);
            }
            case FLOAT: 
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double", new Integer[]{7, 2, 3});
            }
            case BOOLEAN: 
            case SMALLINT: 
            case TINYINT: 
            case INT: 
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, -5, "bigint", new Integer[0]);
            }
            case ARRAY: {
                if (schemaColumn.arrayContent == null) {
                    this.throwUnhandledColumnType(schemaColumn, dataset);
                }
                DSSTypeSQLMapping itemSQLType = this.getSQLType(schemaColumn.arrayContent, dataset);
                return new DSSTypeSQLMapping(Type.ARRAY, 2003, String.format("array(%s)", itemSQLType.sqlDecl), new Integer[0]);
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case OBJECT: {
                this.throwUnhandledColumnType(schemaColumn, dataset);
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        if (sqlType == 2003) {
            Object object = rs2.getObject(colIdx);
            if (object == null) {
                return null;
            }
            try {
                return TreasureDataSQLDialect.parseTrinoArray(object);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Cannot parse Trino array", new Object[0]);
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public SQLUtils.SQLTable getSafeRandomTemporaryTableName(String catalog, String schema, String prefix, String suffix) {
        return new SQLUtils.SQLTable(null, schema, this.getSafeRandomTemporaryTableName(prefix) + suffix);
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return true;
    }

    private static SchemaColumn createSchemaColumnFromSQLTypeName(String columnName, String sqlTypeName) {
        switch (sqlTypeName) {
            case "varchar": {
                return new SchemaColumn(columnName, Type.STRING);
            }
            case "int": 
            case "integer": 
            case "bigint": {
                return new SchemaColumn(columnName, Type.BIGINT);
            }
            case "float": 
            case "double": {
                return new SchemaColumn(columnName, Type.DOUBLE);
            }
        }
        Matcher matcher = ARRAY_REGEX.matcher(sqlTypeName);
        if (matcher.matches()) {
            SchemaColumn column = new SchemaColumn(columnName, Type.ARRAY);
            column.arrayContent = TreasureDataSQLDialect.createSchemaColumnFromSQLTypeName("item", matcher.group(1));
            return column;
        }
        throw new IllegalArgumentException("Unexpected item type: " + sqlTypeName);
    }

    private static String parseTrinoArray(Object object) throws ReflectiveOperationException {
        Object o = object.getClass().getDeclaredMethod("getArray", new Class[0]).invoke(object, new Object[0]);
        return JSON.gson().toJson((JsonElement)TreasureDataSQLDialect.convertArrayToJsonArray((Object[])o));
    }

    private static JsonArray convertArrayToJsonArray(Object array) {
        JsonArray result = new JsonArray();
        if (array != null) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                TreasureDataSQLDialect.addToJsonArray(result, Array.get(array, i));
            }
        }
        return result;
    }

    private static JsonArray convertListToJsonArray(List<?> list) {
        JsonArray result = new JsonArray();
        if (list != null) {
            list.forEach(item -> TreasureDataSQLDialect.addToJsonArray(result, item));
        }
        return result;
    }

    private static void addToJsonArray(JsonArray result, Object item) {
        if (item instanceof Number) {
            result.add((Number)item);
        } else if (item instanceof String) {
            result.add((String)item);
        } else if (item instanceof Array) {
            result.add((JsonElement)TreasureDataSQLDialect.convertArrayToJsonArray(item));
        } else if (item instanceof List) {
            result.add((JsonElement)TreasureDataSQLDialect.convertListToJsonArray((List)item));
        }
    }

    @Override
    public boolean mustForceOutputColumnNameOverrides() {
        return true;
    }
}

