/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.utils.ErrorContext;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class VerticaUtils {
    private static Logger logger = Logger.getLogger((String)"dku.sql.vertica");

    public static void dropPartition(SQLConnectionProvider.SQLConnectionWrapper conn, String quotedTableFullName, String partitionKey) throws SQLException {
        logger.info((Object)("Dropping partition " + partitionKey));
        try (PreparedStatement st2 = conn.prepareStatement("SELECT DROP_PARTITION(?, ?::varchar)");){
            st2.setString(1, quotedTableFullName);
            st2.setString(2, partitionKey);
            st2.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfDatasetIsValidForVertica(Dataset dataset) {
        ErrorContext.push((String)("dataset " + dataset.getName()));
        try {
            if (!dataset.getType().equals("Vertica")) {
                throw ErrorContext.iae((String)"dataset is not of type Vertica");
            }
            if (dataset.getSchema() == null) {
                throw ErrorContext.iae((String)"Vertica dataset needs a schema");
            }
            AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            if ("native".equals(config.partitioningType) && !dataset.getPartitioningSchema().isSingleDimension()) {
                throw ErrorContext.iae((String)"Vertica dataset must have at most 1 dimension");
            }
            String partitionColumnName = null;
            if (dataset.getPartitioningSchema().isPartitioned()) {
                Dimension d = dataset.getPartitioningSchema().getSingleDimension();
                partitionColumnName = d.getName();
            }
            if (partitionColumnName != null) {
                boolean found = false;
                for (SchemaColumn col : dataset.getSchema().getColumns()) {
                    if (!col.getName().equals(partitionColumnName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw ErrorContext.iaef((String)"Partitioning column %s must appear in Vertica schema", (Object)partitionColumnName, (Object[])new Object[0]);
                }
            }
        }
        finally {
            ErrorContext.pop();
        }
    }
}

