/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.utils.GoogleCloudUtils;
import java.io.IOException;

public class BigQueryException
extends IOException {
    private static final long serialVersionUID = 90798094194L;
    private final int code;
    private final GoogleCloudUtils.GoogleCloudError error;
    public static final String RATE_LIMIT_EXCEPTION_MESSAGE = "rateLimitExceeded";

    public BigQueryException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.error = null;
    }

    public BigQueryException(int code, String message, GoogleCloudUtils.GoogleCloudError error) {
        super(message);
        this.code = code;
        this.error = error;
    }

    public BigQueryException(int code, String message) {
        super(message);
        this.code = code;
        this.error = null;
    }

    public BigQueryException(String message, Throwable cause) {
        super(message, cause);
        this.code = 0;
        this.error = null;
    }

    public BigQueryException(String message) {
        super(message);
        this.code = 0;
        this.error = null;
    }

    public int getCode() {
        return this.code;
    }

    public GoogleCloudUtils.GoogleCloudError getError() {
        return this.error;
    }

    public boolean containsRateLimitError() {
        if (this.getError() != null) {
            for (GoogleCloudUtils.GoogleCloudSubError googleCloudSubError : this.getError().errors) {
                if (!googleCloudSubError.reason.contains(RATE_LIMIT_EXCEPTION_MESSAGE)) continue;
                return true;
            }
        }
        return false;
    }

    public static BigQueryException toBigQueryException(Exception e) {
        if (e instanceof BigQueryException) {
            return (BigQueryException)e;
        }
        return new BigQueryException(e.getMessage(), e);
    }
}

