/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ExprDeserializer
extends Enum<ExprDeserializer>
implements JsonDeserializer<QueryAst.Expr> {
    public static final /* enum */ ExprDeserializer INSTANCE = new ExprDeserializer();
    private static Map<String, Class<? extends QueryAst.Expr>> typesMap;
    private static Logger logger;
    private static final /* synthetic */ ExprDeserializer[] $VALUES;

    public static ExprDeserializer[] values() {
        return (ExprDeserializer[])$VALUES.clone();
    }

    public static ExprDeserializer valueOf(String name) {
        return Enum.valueOf(ExprDeserializer.class, name);
    }

    public static void registerType(String type, Class<? extends QueryAst.Expr> clazz) {
        assert (!typesMap.containsKey(type));
        typesMap.put(type, clazz);
    }

    private Class<? extends QueryAst.Expr> getExprType(JsonObject jsonObj) {
        if (!jsonObj.has("type") || jsonObj.get("type").isJsonNull()) {
            throw ErrorContext.iae((String)("Invalid expression element ('type' attibute is required): " + JSON.prettyLog((Object)jsonObj)));
        }
        String exprTypeName = jsonObj.get("type").getAsString();
        if (!typesMap.containsKey(exprTypeName)) {
            throw ErrorContext.iae((String)("Invalid expression type: " + exprTypeName));
        }
        Class<? extends QueryAst.Expr> exprType = typesMap.get(exprTypeName);
        if (exprType == null) {
            throw ErrorContext.iae((String)("Unknown expression type: " + exprTypeName));
        }
        return exprType;
    }

    public QueryAst.Expr deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        try {
            QueryAst.Expr expr = (QueryAst.Expr)JSON.parse((JsonElement)jsonObj, this.getExprType(jsonObj));
            expr.check();
            return expr;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to parse expression: " + JSON.prettyLog((Object)jsonObj)));
            throw e;
        }
    }

    private static /* synthetic */ ExprDeserializer[] $values() {
        return new ExprDeserializer[]{INSTANCE};
    }

    static {
        $VALUES = ExprDeserializer.$values();
        typesMap = new HashMap<String, Class<? extends QueryAst.Expr>>();
        ExprDeserializer.registerType("TABLE", QueryAst.Table.class);
        ExprDeserializer.registerType("QUERY", QueryAst.SelectQuery.class);
        ExprDeserializer.registerType("INLINE_QUERY", QueryAst.InlineQuery.class);
        ExprDeserializer.registerType("COLUMN", QueryAst.Column.class);
        ExprDeserializer.registerType("OPERATOR", QueryAst.OperatorExpr.class);
        ExprDeserializer.registerType("CONSTANT", QueryAst.ConstExpr.class);
        ExprDeserializer.registerType("INLINE_EXPRESSION", QueryAst.InlineExpr.class);
        ExprDeserializer.registerType("CASE", QueryAst.CaseExpr.class);
        ExprDeserializer.registerType("LIST", QueryAst.ListExpr.class);
        ExprDeserializer.registerType("COMMENT", QueryAst.Comment.class);
        ExprDeserializer.registerType("COMBINED_TABLE_LIKES", QueryAst.CombinedTableLikes.class);
        JSON.registerAdapter(QueryAst.Expr.class, (Object)((Object)INSTANCE));
        JSON.registerAdapter(QueryAst.TableLike.class, (Object)((Object)INSTANCE));
        logger = Logger.getLogger((String)"dku.sqlgeneration.serde");
    }
}

