/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.StreamWriterFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.crecipes.sync.CSyncExecutor;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaRecordedState;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.annotation.Autowired;

public class SingletThreadKafkaToDatasetCSyncRecipeExecutor
implements CSyncExecutor {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private KafkaRecordedState currentState;
    private final String recipeFullId;
    private final Dataset target;
    private final StreamingEndpoint source;
    private final long checkpointInterval;
    private final long checkpointMaxRows;
    private final KafkaStreamingEndpointParams params;
    private volatile boolean aborted = false;
    StreamWriter writer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.setodatasetsync.kafkast");

    public SingletThreadKafkaToDatasetCSyncRecipeExecutor(String recipeFullId, StreamingEndpoint source, Dataset target, long checkpointInterval, long checkpointMaxRows) {
        SpringUtils.getInstance().autowire((Object)this);
        this.checkpointMaxRows = checkpointMaxRows;
        this.checkpointInterval = checkpointInterval;
        this.source = source;
        this.target = target;
        this.recipeFullId = recipeFullId;
        this.params = StreamingEndpointsRegistry.getMeta(source).getExpandedParams(source.projectKey, source, KafkaStreamingEndpointParams.class);
    }

    @Override
    public void run(AuthCtx authCtx) throws Exception {
        KafkaConnection conn = (KafkaConnection)this.connectionsDAO.getConnection(authCtx, this.params.connection);
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, this.target);){
            String sourceId = "dss_csync_" + this.recipeFullId;
            this.writer = StreamWriterFactory.build(authCtx, dh, sourceId, 0);
            KafkaFormatDeserializer deserializer = KafkaFormatsFactory.getDeserializer(this.params.formatType, this.params.formatParams);
            KafkaFormatDeserializer keyDeserializer = KafkaFormatsFactory.getDeserializer(this.params.keyFormatType, this.params.keyFormatParams);
            assert (deserializer != null);
            Properties props = conn.buildBasicProperties(authCtx, this.source.getProjectKey());
            for (SimpleKeyValue prop : this.params.consumerParams.properties) {
                if (!StringUtils.isNotBlank((String)prop.key)) continue;
                props.put(prop.key, StringUtils.defaultIfEmpty((String)prop.value, (String)""));
            }
            props.put("key.deserializer", keyDeserializer.getKafkaDeserializer());
            props.put("value.deserializer", deserializer.getKafkaDeserializer());
            props.put("group.id", props.getProperty("group.id.prefix", "dss_csync_") + this.recipeFullId);
            props.put("enable.auto.commit", "false");
            try (KafkaConsumer consumer = new KafkaConsumer(props);){
                consumer.subscribe(Arrays.asList(this.params.topic));
                String recordedState = this.writer.getRecordedState();
                if (recordedState != null) {
                    consumer.poll(1000L);
                    this.currentState = (KafkaRecordedState)JSON.parse((String)recordedState, KafkaRecordedState.class);
                    for (Map.Entry<Integer, Long> krps : this.currentState.recordedOffsets.entrySet()) {
                        logger.info((Object)("Initializing partition: " + String.valueOf(krps.getKey()) + " offset " + String.valueOf(krps.getValue())));
                        consumer.seek(new TopicPartition(this.params.topic, krps.getKey().intValue()), krps.getValue().longValue());
                    }
                } else {
                    this.currentState = new KafkaRecordedState();
                }
                StreamColumnFactory scf = new StreamColumnFactory();
                StreamRowFactory srf = new StreamRowFactory();
                keyDeserializer.init((ColumnFactory)scf, (RowFactory)srf, this.source != null ? this.source.schema : null);
                deserializer.init((ColumnFactory)scf, (RowFactory)srf, this.source != null ? this.source.schema : null);
                StreamColumn timestampColumn = null;
                if (StringUtils.isNotBlank((String)this.params.timestampColumn)) {
                    timestampColumn = scf.column(this.params.timestampColumn);
                }
                this.writer.setColumnFactory((ColumnFactory)scf);
                long lastCheckpoint = System.currentTimeMillis();
                long checkpointSize = 0L;
                logger.info((Object)"Starting to dequeue");
                ArrayList<Row> buffer = new ArrayList<Row>();
                while (!this.aborted) {
                    buffer.clear();
                    ConsumerRecords records = consumer.poll(1000L);
                    for (ConsumerRecord record : records) {
                        if (this.params.consumerParams.ignoreTombstones && record.value() == null) {
                            logger.infoV("Ignoring tombstone record, offset %s", new Object[]{record.offset()});
                            continue;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.traceV("Process record p=%s offset=%d key=%s", new Object[]{record.partition(), record.offset(), record.key()});
                        }
                        Row row = srf.row();
                        keyDeserializer.deserialize(record.key(), row);
                        deserializer.deserialize(record.value(), row);
                        if (timestampColumn != null) {
                            row.put((Column)timestampColumn, DKUDateUtils.isoFormatUTC((long)record.timestamp()));
                        }
                        buffer.add(row);
                    }
                    for (ConsumerRecord record : records) {
                        this.currentState.recordedOffsets.put(record.partition(), record.offset() + 1L);
                    }
                    for (Row row : buffer) {
                        if (logger.isTraceEnabled()) {
                            logger.traceV("Got row: ", new Object[]{row});
                        }
                        this.writer.append(row);
                    }
                    long elapsed = System.currentTimeMillis() - lastCheckpoint;
                    if (elapsed <= this.checkpointInterval && (checkpointSize += (long)buffer.size()) <= this.checkpointMaxRows) continue;
                    logger.info((Object)("Checkpoint on timeout or size : checkpointSize=" + checkpointSize + " elapsed=" + elapsed));
                    this.writer.checkpoint(JSON.json((Object)this.currentState));
                    lastCheckpoint = System.currentTimeMillis();
                    checkpointSize = 0L;
                }
                if (checkpointSize > 0L) {
                    logger.info((Object)"Checkpoint exit");
                    this.writer.checkpoint(JSON.json((Object)this.currentState));
                }
            }
        }
    }

    @Override
    public void abort() {
        this.aborted = true;
    }
}

