/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusherFactory;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamingEndpointService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private ConnectionsTestService connectionsTestService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    private static Logger logger = Logger.getLogger((String)"dip.streaming-endpoints.service");

    public static void checkFeatureFlag() {
        if (!StreamingEndpointService.isStreamingEnabled()) {
            throw new IllegalStateException("Streaming is not available on this instance");
        }
    }

    public static boolean isStreamingEnabled() {
        try {
            return ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().streamingEnabled;
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to check if streaming is activated", (Throwable)e);
            return false;
        }
    }

    public StreamingEndpoint getOrNull(AnyLoc loc) throws IOException {
        return (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(loc);
    }

    private void checkNameUnicity(String projectKey, String name) throws IOException {
        if (this.streamingEndpointsDAO.exists(projectKey, name)) {
            throw ErrorContext.iaef((String)"Streaming endpoint %s.%s must have a unique name", (Object)projectKey, (Object[])new Object[]{name});
        }
        if (this.datasetsDAO.exists(projectKey, name)) {
            throw ErrorContext.iaef((String)"Name %s.%s is already used by a dataset", (Object)projectKey, (Object[])new Object[]{name});
        }
    }

    public StreamingEndpoint create_NT(AuthCtx authCtx, String projectKey, StreamingEndpointProto proto) throws Exception {
        StreamingEndpointService.checkFeatureFlag();
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNameUnicity(projectKey, proto.id);
        }
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(proto.type);
        StreamingEndpoint se = meta.create(proto);
        se.projectKey = projectKey;
        se.creationTag = new VersionTag(authCtx.getIdentifier());
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            meta.checkUsability(authCtx, se);
            this.customPolicyHooksRegistry.onPreObjectSave(authCtx, null, se);
            this.streamingEndpointsDAO.save(se);
            this.flowZonesService.attachObjectToZone(proto.zone, projectKey, se, true);
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STREAMING_ENDPOINT, projectKey, se.id, t.getUser(), TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_CREATE).withDetails(new JsonObject()));
            t.commit("Created streaming endpoint " + projectKey + "." + proto.id);
        }
        return se;
    }

    public StreamingEndpoint create_T(AuthCtx authCtx, String projectKey, String name, StreamingEndpointCreationSettings settings) throws Exception {
        StreamingEndpointService.checkFeatureFlag();
        this.checkNameUnicity(projectKey, name);
        StreamingEndpoint se = this.prepare_T(authCtx, projectKey, name, settings);
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, null, se);
        this.streamingEndpointsDAO.save(se);
        this.flowZonesService.attachObjectToZone(settings.zone, projectKey, se, true);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STREAMING_ENDPOINT, projectKey, se.id, authCtx, TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_CREATE).withDetails(new JsonObject()));
        return se;
    }

    public StreamingEndpoint create_T(AuthCtx authCtx, String projectKey, StreamingEndpoint se) throws Exception {
        StreamingEndpointService.checkFeatureFlag();
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(se.type);
        meta.checkUsability(authCtx, se);
        this.checkNameUnicity(projectKey, se.id);
        this.customPolicyHooksRegistry.onPreObjectSave(authCtx, null, se);
        this.streamingEndpointsDAO.save(se);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STREAMING_ENDPOINT, projectKey, se.id, authCtx, TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_CREATE).withDetails(new JsonObject()));
        return se;
    }

    public StreamingEndpoint prepare_T(AuthCtx authCtx, String projectKey, String name, StreamingEndpointCreationSettings settings) throws Exception {
        DSSConnection connection = ConnectionsDAO.get().getMandatoryConnection(authCtx, settings.connectionId);
        StreamingEndpointProto proto = new StreamingEndpointProto();
        proto.id = name;
        proto.type = connection.getType().toLowerCase();
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(proto.type);
        StreamingEndpoint se = meta.create(proto);
        se.projectKey = projectKey;
        se.creationTag = new VersionTag(authCtx.getIdentifier());
        meta.fillManagedParams(se, connection, settings.formatOptionId);
        meta.checkUsability(authCtx, se);
        return se;
    }

    public StreamingEndpoint save(StreamingEndpoint si, boolean creation) throws IOException, TransactionContextError, DKUSecurityException, CodedException {
        return this.save(TransactionContext.retrieveWrite(), si.projectKey, si, creation, true);
    }

    public StreamingEndpoint save(RWTransactionRef t, String projectKey, StreamingEndpoint si) throws IOException, DKUSecurityException, CodedException {
        return this.save(t, projectKey, si, false);
    }

    public StreamingEndpoint save(RWTransactionRef t, String projectKey, StreamingEndpoint si, boolean creation) throws IOException, DKUSecurityException, CodedException {
        return this.save(t, projectKey, si, creation, true);
    }

    public StreamingEndpoint saveWithoutEvent(RWTransactionRef t, String projectKey, StreamingEndpoint si) throws IOException, DKUSecurityException, CodedException {
        return this.save(t, projectKey, si, false, false);
    }

    private StreamingEndpoint save(RWTransactionRef t, String projectKey, StreamingEndpoint se, boolean creation, boolean withEvent) throws IOException, DKUSecurityException, CodedException {
        StreamingEndpointService.checkFeatureFlag();
        if (creation) {
            this.checkNameUnicity(projectKey, se.id);
        }
        StreamingEndpoint preExisting = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(projectKey, se.id);
        if (creation && preExisting != null) {
            throw new IllegalArgumentException("Streaming endpoint already exists");
        }
        VersionTag existingTag = preExisting == null ? null : preExisting.versionTag;
        VersionTag updatedTag = VersionTag.increment(existingTag, t.getUser().getIdentifier());
        StreamingEndpoint copy = (StreamingEndpoint)JSON.deepCopy((Object)se);
        copy.versionTag = updatedTag;
        if (copy.creationTag == null) {
            copy.creationTag = preExisting != null && preExisting.creationTag != null ? preExisting.creationTag : new VersionTag(t.getUser().getIdentifier());
        }
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(copy.type);
        meta.checkUsability(t.getUser(), copy);
        logger.info((Object)("Save streaming endpoint si=" + JSON.log((Object)se) + " copy=" + JSON.log((Object)copy)));
        this.taggingService.onObjectSaved(projectKey, copy.tags);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), preExisting, se);
        this.streamingEndpointsDAO.save(copy);
        if (withEvent) {
            JsonObject details = new JsonObject();
            if (preExisting != null) {
                TaggableObjectDiffService.addTagEditInfoIfNeeded(preExisting, copy, details);
            }
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STREAMING_ENDPOINT, projectKey, copy.id, t.getUser(), TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_EDIT).withDetails(details));
        }
        return copy;
    }

    public void performDeletion(AuthCtx authCtx, String projectKey, String seId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), (TaggableObjectsService.TaggableObject)this.streamingEndpointsDAO.getOrNull(projectKey, seId));
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, projectKey, seId, ignored);
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
            this.recipeSaveService.delete(recipe.projectKey, recipe.name);
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STREAMING_ENDPOINT, projectKey, seId, t.getUser(), TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_DELETE).withDetails(new JsonObject()));
        this.streamingEndpointsDAO.delete(projectKey, seId);
        this.exploresService.deleteCapture(projectKey, seId);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String folderId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        return this.computeDeletionImpact(authCtx, null, projectKey, folderId, ignored);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nullable String contextProjectKey, String projectKey, String folderId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        AnyLoc streamingEndpointLoc = new AnyLoc(projectKey, folderId);
        List<SerializedRecipe> connectedRecipes = this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(streamingEndpointLoc);
        for (SerializedRecipe sr2 : connectedRecipes) {
            this.addRecipeToDeletionImpact(sr2, di, ignored);
        }
        if (contextProjectKey != null) {
            this.recipesDAO.listUnsafe(contextProjectKey).stream().filter(sr -> sr.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(streamingEndpointLoc)) || sr.getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(streamingEndpointLoc))).forEach(sr -> this.addRecipeToDeletionImpact((SerializedRecipe)sr, di, ignored));
        }
        TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
        availableOptions.shouldGiveOptionToDropData = false;
        di.availableOptions.put(projectKey + "." + folderId, availableOptions);
        return di;
    }

    private void addRecipeToDeletionImpact(SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(sr.getProjectKey(), ITaggingService.TaggableType.RECIPE, sr.name))) {
            di.deletedRecipes.add(new TaggableObjectsDeletionService.ImpactedRecipe(sr.getProjectKey(), sr.name, sr.type));
        }
    }

    public KafkaTestResult testKafka_NT(AuthCtx authCtx, StreamingEndpoint streamingEndpoint) {
        if (!"kafka".equals(streamingEndpoint.type)) {
            throw new IllegalArgumentException("Incorrect streaming endpoint type");
        }
        KafkaTestResult ret = new KafkaTestResult();
        try {
            KafkaStreamingEndpointParams seParams = streamingEndpoint.getParamsAs(KafkaStreamingEndpointParams.class);
            KafkaConnection conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, seParams.connection, KafkaConnection.class);
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("User cannot access connection " + conn.name);
            }
            ConnectionsTestService.KafkaTestResult connResult = this.connectionsTestService.testKafka(authCtx, conn);
            ret.topics = connResult.topics;
            ret.connectionOk = connResult.ok;
            ret.connectionError = connResult.message;
        }
        catch (Exception e) {
            logger.warn((Object)"SQS test failed", (Throwable)e);
            ret.connectionOk = false;
            ret.connectionError = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    public SQSTestResult testSQS_NT(AuthCtx authCtx, StreamingEndpoint streamingEndpoint) {
        if (!"sqs".equals(streamingEndpoint.type)) {
            throw new IllegalArgumentException("Incorrect streaming endpoint type");
        }
        SQSTestResult ret = new SQSTestResult();
        try {
            SQSStreamingEndpointParams seParams = streamingEndpoint.getParamsAs(SQSStreamingEndpointParams.class);
            SQSConnection conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, seParams.connection, SQSConnection.class);
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("User cannot access connection " + conn.name);
            }
            ConnectionsTestService.SQSTestResult connResult = this.connectionsTestService.testSQS(authCtx, conn);
            ret.queues = connResult.queues;
            ret.connectionOk = connResult.ok;
            ret.connectionError = connResult.message;
        }
        catch (Exception e) {
            logger.warn((Object)"Kafka test failed", (Throwable)e);
            ret.connectionOk = false;
            ret.connectionError = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    public HttpSSETestResult testHttpSSE_NT(StreamingEndpoint streamingEndpoint) {
        if (!"httpsse".equals(streamingEndpoint.type)) {
            throw new IllegalArgumentException("Incorrect streaming endpoint type");
        }
        HttpSSETestResult ret = new HttpSSETestResult();
        try {
            HTTPSSEStreamingEndpointParams seParams = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, HTTPSSEStreamingEndpointParams.class);
            if (StringUtils.isBlank((String)seParams.url)) {
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Missing or empty URL parameter. Make sure it is set in the endpoint settings.");
            }
            CloseableHttpClient client = HttpClientBuilder.create().addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategyWithIPBlacklist(new ProxySettings())).build();
            IPBlacklistVerifier.validateUriNotBlacklisted(seParams.url, false);
            HttpGet get = new HttpGet(seParams.url);
            get.addHeader("Accept", "text/event-stream");
            try (CloseableHttpResponse resp = client.execute((HttpUriRequest)get);){
                if (resp.getStatusLine().getStatusCode() == 200) {
                    ret.connectionOk = true;
                } else {
                    ret.connectionOk = false;
                    ret.connectionError = "Request failed: " + resp.getStatusLine().getStatusCode();
                }
            }
        }
        catch (Exception e) {
            ret.connectionOk = false;
            ret.connectionError = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    public FutureResponse<StreamingEndpointSample> collectSample(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, int limit, int timeout, boolean inferStorageTypes) throws Exception {
        StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(streamingEndpoint);
        meta.checkUsability(authCtx, streamingEndpoint);
        CollectStreamingEndpointSampleThread ft = new CollectStreamingEndpointSampleThread(authCtx, streamingEndpoint, limit, timeout, inferStorageTypes);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<StreamingEndpointSample>>(){});
    }

    public FetchKafkaSchemaResult fetchKafkaSchema_NT(AuthCtx authCtx, StreamingEndpoint streamingEndpoint) throws Exception {
        if (!"kafka".equals(streamingEndpoint.type)) {
            throw new IllegalArgumentException("Incorrect streaming endpoint type");
        }
        FetchKafkaSchemaResult ret = new FetchKafkaSchemaResult();
        try {
            StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(streamingEndpoint);
            KafkaStreamingEndpointParams params = meta.getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, KafkaStreamingEndpointParams.class);
            KafkaConnection conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, params.connection, KafkaConnection.class);
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("User cannot access connection " + conn.name);
            }
            Properties props = conn.buildBasicProperties(authCtx, streamingEndpoint.getProjectKey());
            for (SimpleKeyValue prop : params.consumerParams.properties) {
                if (!StringUtils.isNotBlank((String)prop.key)) continue;
                props.put(prop.key, StringUtils.defaultIfEmpty((String)prop.value, (String)""));
            }
            KafkaFormatDeserializer valueSeserializer = KafkaFormatsFactory.getDeserializer(params.formatType, params.formatParams);
            KafkaFormatDeserializer keyDeserializer = KafkaFormatsFactory.getDeserializer(params.keyFormatType, params.keyFormatParams);
            Schema keySchema = keyDeserializer.fetchSchema(props, params.topic, true);
            Schema valueSchema = valueSeserializer.fetchSchema(props, params.topic, false);
            Schema schema = new Schema();
            for (SchemaColumn c2 : keySchema.columns) {
                if (schema.getColumn(c2.getName()) != null) continue;
                schema.addColumn(c2);
            }
            for (SchemaColumn c2 : valueSchema.columns) {
                if (schema.getColumn(c2.getName()) != null) continue;
                schema.addColumn(c2);
            }
            if (StringUtils.isNotBlank((String)params.timestampColumn) && schema.getColumn(params.timestampColumn) == null) {
                schema.addColumn(params.timestampColumn, Type.DATE);
            }
            ret.detectedSchema = schema;
            ret.schemaDetection = SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS, streamingEndpoint.schema, SchemaDetection.Mode.CONSISTENCY_CHECK, ret.detectedSchema);
        }
        catch (Exception e) {
            logger.error((Object)"Kafka schema fetch failed", (Throwable)e);
            ret.fetchError = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    public static class StreamingEndpointProto {
        public String id;
        public String type;
        public String zone;
        public String connection;
    }

    public static class StreamingEndpointCreationSettings {
        public String connectionId;
        public String formatOptionId;
        public String zone;
    }

    public static class KafkaTestResult {
        public boolean connectionOk;
        public String connectionError;
        public List<String> topics = Lists.newArrayList();
    }

    public static class SQSTestResult {
        public boolean connectionOk;
        public String connectionError;
        public List<String> queues = Lists.newArrayList();
    }

    public static class HttpSSETestResult {
        public boolean connectionOk;
        public String connectionError;
    }

    public static class CollectStreamingEndpointSampleThread
    extends SimpleFutureThread<StreamingEndpointSample>
    implements StreamingEndpointSimpleConsumer {
        private final StreamingEndpoint streamingEndpoint;
        private final int limit;
        private final int timeout;
        private final boolean inferStorageTypes;
        private final MemTable sample;
        private volatile boolean collecting;
        private FutureProgressState state;

        public CollectStreamingEndpointSampleThread(AuthCtx owner, StreamingEndpoint streamingEndpoint, int limit, int timeout, boolean inferStorageTypes) {
            super(owner);
            this.streamingEndpoint = streamingEndpoint;
            this.limit = limit;
            this.timeout = timeout;
            this.inferStorageTypes = inferStorageTypes;
            this.sample = new MemTable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected StreamingEndpointSample compute() throws Exception {
            Schema detectedSchema;
            StreamingEndpointSample ret = new StreamingEndpointSample();
            this.collecting = true;
            this.state = FutureProgress.pushState((String)"Capturing records", (double)this.limit, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);
            final StreamingEndpointSimplePusher driver = new StreamingEndpointSimplePusherFactory().build(this.owner, this.streamingEndpoint, true);
            Thread interruptor = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timeout);
                        if (collecting) {
                            driver.interrupt();
                            this.interrupt();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)"Timeout-producing thread interrupted");
                    }
                }
            });
            interruptor.start();
            try {
                driver.run(this, null, this.sample, this.sample, null);
            }
            catch (InterruptedException e) {
                logger.info((Object)"Stream capture timeouted");
            }
            catch (InterruptException e) {
                logger.info((Object)"Stream capture timeouted");
            }
            catch (SamplesCollectionLimitReachedException e) {
                logger.info((Object)"Collected enough samples");
            }
            finally {
                this.collecting = false;
                Thread.interrupted();
            }
            TypeInferrer2 inferer = new TypeInferrer2();
            inferer.processFullAuto(null, this.sample);
            ret.table = new SerializedMemTableSimple();
            ret.table.fromMemTable(this.sample, 0, this.sample.nrows());
            if (this.inferStorageTypes) {
                detectedSchema = SchemaDetection.buildDetectedSchemaWithStorageTypesInference(this.sample);
            } else {
                detectedSchema = new Schema();
                for (Column col : this.sample.columns()) {
                    detectedSchema.addColumn(col.getName(), Type.STRING);
                }
            }
            ret.schemaDetection = SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS, this.streamingEndpoint.schema, SchemaDetection.Mode.CONSISTENCY_CHECK, detectedSchema);
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"collect_sample", (String)"Collect sample from streaming endpoint");
        }

        @Override
        public void onRow(Row row) throws Exception {
            this.sample.appendRow(row);
            if (this.state != null) {
                this.state.increment(1.0);
            }
            if (this.sample.nrows() >= this.limit) {
                throw new SamplesCollectionLimitReachedException();
            }
        }

        @Override
        public void onNewState(String state) throws Exception {
        }
    }

    public static class FetchKafkaSchemaResult {
        public Schema detectedSchema;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
        public String fetchError;
    }

    public static class SamplesCollectionLimitReachedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class StreamingEndpointSample {
        public SerializedMemTableSimple table;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
    }
}

