/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaSimplePuller;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.ToKafkaStreamer;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class KafkaStreamingEndpointMeta
extends StreamingEndpointMeta {
    public static final String TYPE = "kafka";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass() {
        return KafkaStreamingEndpointParams.class;
    }

    @Override
    public StreamingEndpointSimpleWriter getSimpleWriter(AuthCtx authCtx, StreamingEndpoint targetSE, ColumnFactory cf, WarningsContext warningsContext) throws Exception {
        return new ToKafkaStreamer(authCtx, targetSE, cf, warningsContext);
    }

    @Override
    public StreamingEndpointSimplePuller getSimplePuller(AuthCtx authCtx, StreamingEndpoint sourceSE, boolean nonConsuming) {
        return new KafkaSimplePuller(authCtx, this.getExpandedParams(sourceSE.projectKey, sourceSE, KafkaStreamingEndpointParams.class));
    }

    @Override
    public void fillManagedParams(StreamingEndpoint se, DSSConnection connection, String formatOptionId) {
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        params.formatType = StringUtils.defaultIfBlank((String)formatOptionId, (String)"json").toLowerCase();
        params.topic = "${projectKey}-${seId}";
        params.connection = connection.name;
    }

    @Override
    public void fillCopyParams(StreamingEndpoint se) {
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        params.topic = "${projectKey}-${seId}";
    }

    @Override
    public void checkUsability(AuthCtx authCtx, StreamingEndpoint se) throws DKUSecurityException, IOException {
        DSSConnection connection;
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        if (!StringUtils.isBlank((String)params.connection) && (connection = ConnectionsDAO.get().getConnectionUnsafeUnexpanded(authCtx, params.connection)) != null && !connection.isFreelyUsableBy(authCtx)) {
            throw new DKUSecurityException("User is not allowed to access connection " + params.connection);
        }
    }

    @Override
    public <T extends StreamingEndpoint.StreamingEndpointParams> T getExpandedParams(String projectKey, StreamingEndpoint se, Class<T> clazz) {
        KafkaStreamingEndpointParams params = (KafkaStreamingEndpointParams)JSON.deepCopy((Object)se.getParamsAs(KafkaStreamingEndpointParams.class));
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(projectKey);
        vc.add("projectKey", se.projectKey);
        vc.add("seId", se.id);
        params.topic = vc.expand(params.topic);
        for (SimpleKeyValue prop : params.consumerParams.properties) {
            prop.value = vc.expand(prop.value);
        }
        return (T)((StreamingEndpoint.StreamingEndpointParams)clazz.cast(params));
    }

    @Override
    public StreamingEndpoint create(StreamingEndpointService.StreamingEndpointProto proto) throws InstantiationException, IllegalAccessException {
        StreamingEndpoint se = super.create(proto);
        se.getParamsAs(KafkaStreamingEndpointParams.class).connection = proto.connection;
        return se;
    }
}

