/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.git.ObjectSpecificDiffBuilder;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitCommitSeparator {
    private DSSGitModel.GitMode gitMode;
    private DSSGitModel.PluginGitMode pluginGitMode;
    private static Logger logger = Logger.getLogger((String)"dku.git.commits");

    public GitCommitSeparator(DSSGitModel.GitMode gitMode) {
        this.gitMode = gitMode;
    }

    public GitCommitSeparator(DSSGitModel.GitMode gitMode, DSSGitModel.PluginGitMode pluginGitMode) {
        this.gitMode = gitMode;
        this.pluginGitMode = pluginGitMode;
    }

    private List<DSSCommitDef> commitDefsByProject(List<RelFile> changes, GitModel.GitAuthor author, String message) {
        ArrayList<DSSCommitDef> ret = new ArrayList<DSSCommitDef>();
        ArrayList<RelFile> global = new ArrayList<RelFile>();
        HashMultimap map = HashMultimap.create();
        for (RelFile rf : changes) {
            if (rf.getElements().length > 2 && "projects".equals(rf.getElements()[0])) {
                String project = rf.getElements()[1];
                map.put((Object)project, (Object)rf);
                continue;
            }
            global.add(rf);
        }
        for (String projectKey : map.keySet()) {
            ret.add(new DSSCommitDef(DSSCommitDef.CommitDefType.PROJECT, projectKey, author, message, map.get((Object)projectKey)));
        }
        if (!global.isEmpty()) {
            ret.add(new DSSCommitDef(DSSCommitDef.CommitDefType.GLOBAL, null, author, message, global));
        }
        return ret;
    }

    public List<DSSCommitDef> commitDefsFromChanges(List<RelFile> changes, GitModel.GitAuthor author, String message, File root) {
        if (this.pluginGitMode != null) {
            try {
                if (DKUFileUtils.isWithinOrSame((File)ApplicationConfigurator.getFile((String)"plugins"), (File)root)) {
                    String pluginId = this.pluginGitMode == DSSGitModel.PluginGitMode.GLOBAL ? null : root.getName();
                    return Lists.newArrayList((Object[])new DSSCommitDef[]{new DSSCommitDef(DSSCommitDef.CommitDefType.PLUGIN, pluginId, author, message, changes)});
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Could not check the transaction commit type (plugin/project): " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
            List<DSSCommitDef> byProject = this.commitDefsByProject(changes, author, message);
            if (byProject.size() == 1 && byProject.get((int)0).itemId != null) {
                return byProject;
            }
            return Lists.newArrayList((Object[])new DSSCommitDef[]{new DSSCommitDef(DSSCommitDef.CommitDefType.GLOBAL, null, author, message, changes)});
        }
        return this.commitDefsByProject(changes, author, message);
    }

    public TreeFilter objectTreeFilter(TaggableObjectsService.TaggableObjectRef object) {
        PathFilter tf = null;
        switch (object.type) {
            case DATASET: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = PathFilter.create((String)("projects/" + object.projectKey + "/datasets/" + object.id + ".json"));
                    break;
                }
                tf = PathFilter.create((String)("datasets/" + object.id + ".json"));
                break;
            }
            case STREAMING_ENDPOINT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = PathFilter.create((String)("projects/" + object.projectKey + "/streaming-endpoints/" + object.id + ".json"));
                    break;
                }
                tf = PathFilter.create((String)("streaming-endpoints/" + object.id + ".json"));
                break;
            }
            case RECIPE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/recipes", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("recipes", object.id);
                break;
            }
            case LABELING_TASK: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/labeling_tasks", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("labeling_tasks", object.id);
                break;
            }
            case SCENARIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/scenarios", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("scenarios", object.id);
                break;
            }
            case INSIGHT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/insights", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("insights", object.id);
                break;
            }
            case DASHBOARD: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/dashboards", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("dashboards", object.id);
                break;
            }
            case WEB_APP: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/web_apps", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("web_apps", object.id);
                break;
            }
            case CODE_STUDIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/code_studios", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("code_studios", object.id);
                break;
            }
            case REPORT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/code-reports", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("code-reports", object.id);
                break;
            }
            case ARTICLE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/wiki/articles", object.id + ".");
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("wiki/articles", object.id + ".");
                break;
            }
            case AGENT_TOOL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/agent-tools", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("agent-tools", object.id);
                break;
            }
            case SEMANTIC_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/semantic-models", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("semantic-models", object.id);
                break;
            }
            case PROJECT: {
                if (this.gitMode != DSSGitModel.GitMode.GLOBAL) break;
                tf = PathFilter.create((String)("projects/" + object.projectKey));
                break;
            }
            case SAVED_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("projects/" + object.projectKey + "/saved_models", object.id);
                    break;
                }
                tf = new ObjectSpecificDiffBuilder.DKUPathPrefixFilter("saved_models", object.id);
                break;
            }
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case JUPYTER_NOTEBOOK: 
            case LAMBDA_SERVICE: 
            case MANAGED_FOLDER: 
            case MODEL_EVALUATION_STORE: 
            case SQL_NOTEBOOK: 
            case SEARCH_NOTEBOOK: 
            case DATA_COLLECTION: 
            case FLOW_ZONE: {
                throw new NotImplementedException();
            }
            case API_DEPLOYER_INFRA: {
                tf = PathFilter.create((String)("api-deployer/infras/" + object.id + ".json"));
                break;
            }
            case API_DEPLOYER_SERVICE: {
                tf = PathFilter.create((String)("api-deployer/published-services/" + object.id + ".json"));
                break;
            }
            case API_DEPLOYER_DEPLOYMENT: {
                tf = PathFilter.create((String)("api-deployer/deployments/" + object.id + ".json"));
                break;
            }
            case PROJECT_DEPLOYER_INFRA: {
                tf = PathFilter.create((String)("project-deployer/infras/" + object.id + ".json"));
                break;
            }
            case PROJECT_DEPLOYER_PROJECT: {
                tf = PathFilter.create((String)("project-deployer/projects/" + object.id + ".json"));
                break;
            }
            case PROJECT_DEPLOYER_DEPLOYMENT: {
                tf = PathFilter.create((String)("project-deployer/deployments/" + object.id + ".json"));
                break;
            }
            case CODE_STUDIO_TEMPLATE: {
                tf = PathFilter.create((String)("code_studio_templates/" + object.id + ".json"));
            }
        }
        return tf;
    }

    private List<String> filePatternsForPrefix(RelFile folderRf, File root, String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        File folder = folderRf.resolve(root);
        if (folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                logger.info((Object)("Adding file " + String.valueOf(f)));
                if (!f.getName().startsWith(prefix)) continue;
                ret.add(new RelFile(folderRf, new String[]{f.getName()}).getFullPath());
            }
        }
        return ret;
    }

    public String existingGitFilePathFor(RelFile globalRelFile) {
        if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
            return globalRelFile.getFullPath();
        }
        return globalRelFile.skipHead(2).getFullPath();
    }

    public List<String> existingGitFilePathsForObject(TaggableObjectsService.TaggableObjectRef object) {
        ArrayList<String> filePaths = new ArrayList<String>();
        switch (object.type) {
            case DATASET: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePaths.add(new RelFile(new String[]{"projects", object.projectKey, "datasets", object.id + ".json"}).getFullPath());
                    break;
                }
                filePaths.add(new RelFile(new String[]{"datasets", object.id + ".json"}).getFullPath());
                break;
            }
            case STREAMING_ENDPOINT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePaths.add(new RelFile(new String[]{"projects", object.projectKey, "streaming-endpoints", object.id + ".json"}).getFullPath());
                    break;
                }
                filePaths.add(new RelFile(new String[]{"streaming-endpoints", object.id + ".json"}).getFullPath());
                break;
            }
            case RECIPE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "recipes"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"recipes"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                logger.info((Object)("project folder " + String.valueOf(projectFolder)));
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case PROJECT: {
                if (this.gitMode != DSSGitModel.GitMode.GLOBAL) break;
                filePaths.add(new RelFile(new String[]{"projects", object.projectKey}).getFullPath());
                break;
            }
            case SCENARIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "scenarios"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"scenarios"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case INSIGHT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "insights"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"insights"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case WEB_APP: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "web_apps"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"web_apps"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case CODE_STUDIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "code_studios"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"code_studios"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case REPORT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "code-reports"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"code-reports"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case ARTICLE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "wiki", "articles"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"wiki", "articles"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case AGENT_TOOL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "agent-tools"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"agent-tools"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case SEMANTIC_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "semantic-models"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"semantic-models"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case LABELING_TASK: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePaths.add(new RelFile(new String[]{"projects", object.projectKey, "labeling_tasks", object.id + ".json"}).getFullPath());
                    break;
                }
                filePaths.add(new RelFile(new String[]{"labeling_tasks", object.id + ".json"}).getFullPath());
                break;
            }
            case SAVED_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "saved_models"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePaths.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"saved_models"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePaths.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case DASHBOARD: 
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case JUPYTER_NOTEBOOK: 
            case LAMBDA_SERVICE: 
            case MANAGED_FOLDER: 
            case MODEL_EVALUATION_STORE: 
            case SQL_NOTEBOOK: 
            case SEARCH_NOTEBOOK: 
            case DATA_COLLECTION: 
            case FLOW_ZONE: {
                throw new NotImplementedException();
            }
            case API_DEPLOYER_INFRA: {
                filePaths.add(new RelFile(new String[]{"api-deployer", "infras", object.id + ".json"}).getFullPath());
                break;
            }
            case API_DEPLOYER_SERVICE: {
                filePaths.add(new RelFile(new String[]{"api-deployer", "published-services", object.id + ".json"}).getFullPath());
                break;
            }
            case API_DEPLOYER_DEPLOYMENT: {
                filePaths.add(new RelFile(new String[]{"api-deployer", "deployments", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_INFRA: {
                filePaths.add(new RelFile(new String[]{"project-deployer", "infras", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_PROJECT: {
                filePaths.add(new RelFile(new String[]{"project-deployer", "projects", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_DEPLOYMENT: {
                filePaths.add(new RelFile(new String[]{"project-deployer", "deployments", object.id + ".json"}).getFullPath());
                break;
            }
            case CODE_STUDIO_TEMPLATE: {
                filePaths.add(new RelFile(new String[]{"code_studio_templates", object.id + ".json"}).getFullPath());
            }
        }
        logger.info((Object)("file paths for " + String.valueOf(object) + " -> " + JSON.log(filePaths)));
        return filePaths;
    }

    public DSSCommitDef commitDefForObect(TaggableObjectsService.TaggableObjectRef object, GitModel.GitAuthor author, String message) {
        ArrayList<String> filePatterns = new ArrayList<String>();
        switch (object.type) {
            case DATASET: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePatterns.add(new RelFile(new String[]{"projects", object.projectKey, "datasets", object.id + ".json"}).getFullPath());
                    break;
                }
                filePatterns.add(new RelFile(new String[]{"datasets", object.id + ".json"}).getFullPath());
                break;
            }
            case STREAMING_ENDPOINT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePatterns.add(new RelFile(new String[]{"projects", object.projectKey, "streaming-endpoints", object.id + ".json"}).getFullPath());
                    break;
                }
                filePatterns.add(new RelFile(new String[]{"streaming-endpoints", object.id + ".json"}).getFullPath());
                break;
            }
            case LABELING_TASK: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePatterns.add(new RelFile(new String[]{"projects", object.projectKey, "labeling_tasks", object.id + ".json"}).getFullPath());
                    break;
                }
                filePatterns.add(new RelFile(new String[]{"labeling_tasks", object.id + ".json"}).getFullPath());
                break;
            }
            case RECIPE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "recipes"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"recipes"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case SCENARIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "scenarios"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"scenarios"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case DASHBOARD: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "dashboards"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"dashboards"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case INSIGHT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "insights"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"insights"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case WEB_APP: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "web_apps"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"web_apps"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case CODE_STUDIO: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "code_studios"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"code_studios"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case REPORT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "code-reports"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"code-reports"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case ARTICLE: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "wiki", "articles"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id + "."));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"wiki", "articles"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id + "."));
                break;
            }
            case AGENT_TOOL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "agent-tools"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"agent-tools"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case SEMANTIC_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "semantic-models"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"semantic-models"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case PROJECT: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    filePatterns.add(new RelFile(new String[]{"projects", object.projectKey}).getFullPath());
                    break;
                }
                filePatterns.add(".");
                break;
            }
            case SAVED_MODEL: {
                if (this.gitMode == DSSGitModel.GitMode.GLOBAL) {
                    RelFile prefix = new RelFile(new String[]{"projects", object.projectKey, "saved_models"});
                    File configRoot = ApplicationConfigurator.getFile((String)"config");
                    filePatterns.addAll(this.filePatternsForPrefix(prefix, configRoot, object.id));
                    break;
                }
                RelFile prefix = new RelFile(new String[]{"saved_models"});
                File projectFolder = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", object.projectKey});
                filePatterns.addAll(this.filePatternsForPrefix(prefix, projectFolder, object.id));
                break;
            }
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case JUPYTER_NOTEBOOK: 
            case LAMBDA_SERVICE: 
            case MANAGED_FOLDER: 
            case MODEL_EVALUATION_STORE: 
            case SEARCH_NOTEBOOK: 
            case DATA_COLLECTION: 
            case FLOW_ZONE: {
                throw new NotImplementedException();
            }
            case API_DEPLOYER_INFRA: {
                filePatterns.add(new RelFile(new String[]{"api-deployer", "infras", object.id + ".json"}).getFullPath());
                break;
            }
            case API_DEPLOYER_SERVICE: {
                filePatterns.add(new RelFile(new String[]{"api-deployer", "published-services", object.id + ".json"}).getFullPath());
                break;
            }
            case API_DEPLOYER_DEPLOYMENT: {
                filePatterns.add(new RelFile(new String[]{"api-deployer", "deployments", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_INFRA: {
                filePatterns.add(new RelFile(new String[]{"project-deployer", "infras", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_PROJECT: {
                filePatterns.add(new RelFile(new String[]{"project-deployer", "projects", object.id + ".json"}).getFullPath());
                break;
            }
            case PROJECT_DEPLOYER_DEPLOYMENT: {
                filePatterns.add(new RelFile(new String[]{"project-deployer", "deployments", object.id + ".json"}).getFullPath());
                break;
            }
            case CODE_STUDIO_TEMPLATE: {
                filePatterns.add(new RelFile(new String[]{"code_studio_templates", object.id + ".json"}).getFullPath());
            }
        }
        return new DSSCommitDef(DSSCommitDef.CommitDefType.PROJECT, object.projectKey, author, message, filePatterns);
    }
}

