/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.cli;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import org.apache.commons.lang.StringUtils;

class GitConfigurationRulesHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.git.security");

    GitConfigurationRulesHelper() {
    }

    static void checkIfGitRemoteURLAllowed(AuthCtx authCtx, String url) throws UnauthorizedException {
        if (StringUtils.isBlank((String)url)) {
            throw new UnauthorizedException("Remote URL is blank, cannot check against authorized remotes", "git-usage-denied");
        }
        if (url.startsWith("/") || url.startsWith("file://")) {
            logger.info((Object)("Url '" + url + "' is local, not checking if access to the remote git is allowed for the user"));
        } else {
            GitConfigurationRulesHelper.getMatchingRuleOrThrow(authCtx, url);
        }
    }

    static GeneralSettingsDAO.GitEnforcedConfigurationRule getMatchingRuleOrThrow(AuthCtx authCtx, String remoteURL) throws UnauthorizedException {
        GeneralSettingsDAO.GitSettings gitSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().git;
        if (DKUApp.getParams().getBoolParam("dku.git.security.legacyGroupBasedOnlyRulesMatching", false)) {
            GeneralSettingsDAO.GitEnforcedConfigurationRule matchedRule = null;
            for (GeneralSettingsDAO.GitEnforcedConfigurationRule rule : gitSettings.enforcedConfigurationRules) {
                if (StringUtils.isBlank((String)rule.groupName)) {
                    matchedRule = rule;
                    break;
                }
                if (!authCtx.isGroupsAware() || !authCtx.getGroupsIfRelevant().contains(rule.groupName)) continue;
                matchedRule = rule;
                break;
            }
            if (matchedRule != null) {
                if (!matchedRule.allowGit) {
                    throw new UnauthorizedException("Remote Git usage is forbidden for auth=" + authCtx.getIdentifier(), "git-usage-denied");
                }
                if (matchedRule.remoteWhitelist == null || matchedRule.remoteWhitelist.contains("*")) {
                    return matchedRule;
                }
                for (String whitelistRegexp : matchedRule.remoteWhitelist) {
                    if (!remoteURL.matches(whitelistRegexp)) continue;
                    return matchedRule;
                }
                throw new UnauthorizedException("Usage of this remote Git URL is not allowed by remote whitelist remoteURL=" + UrlRedactionUtils.sanitizeHttpUrls((String)remoteURL), "git-usage-denied");
            }
            logger.warn((Object)("Rules:" + JSON.log((Object)gitSettings)));
            throw new UnauthorizedException("No Git configuration group rule matched for " + String.valueOf(authCtx) + ", Git access denied", "git-usage-denied");
        }
        for (GeneralSettingsDAO.GitEnforcedConfigurationRule rule : gitSettings.enforcedConfigurationRules) {
            boolean groupOK = false;
            if (StringUtils.isBlank((String)rule.groupName)) {
                groupOK = true;
            }
            if (authCtx.isGroupsAware() && authCtx.getGroupsIfRelevant().contains(rule.groupName)) {
                groupOK = true;
            }
            if (!groupOK) continue;
            if (rule.remoteWhitelist == null || rule.remoteWhitelist.contains("*")) {
                if (!rule.allowGit) {
                    throw new UnauthorizedException("Remote Git usage is forbidden for auth=" + authCtx.getIdentifier() + ", remoteURL=" + UrlRedactionUtils.sanitizeHttpUrls((String)remoteURL), "git-usage-denied");
                }
                return rule;
            }
            for (String whitelistRegexp : rule.remoteWhitelist) {
                if (!remoteURL.matches(whitelistRegexp)) continue;
                if (!rule.allowGit) {
                    throw new UnauthorizedException("Remote Git usage is forbidden for auth=" + authCtx.getIdentifier() + ", remoteURL=" + UrlRedactionUtils.sanitizeHttpUrls((String)remoteURL), "git-usage-denied");
                }
                return rule;
            }
        }
        logger.warn((Object)("Rules:" + JSON.log((Object)gitSettings)));
        throw new UnauthorizedException("No Git configuration group rule matched for auth=" + String.valueOf(authCtx) + ", remoteURL=" + UrlRedactionUtils.sanitizeHttpUrls((String)remoteURL) + ", Git access denied", "git-usage-denied");
    }
}

