/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSSGitUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.git");

    public static String getDefaultBranchUnreliably() {
        try {
            File generalSettingsFile = ApplicationConfigurator.getFile((String[])new String[]{"config", "general-settings.json"});
            if (generalSettingsFile.exists()) {
                GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)JSON.parseFile((File)generalSettingsFile, GeneralSettingsDAO.GeneralSettings.class);
                return gs.git.defaultBaseBranch;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read general-settings.json to get the default base branch", (Throwable)e);
        }
        return null;
    }

    public static void generateDkuProjectsGitignore() throws IOException {
        File globalGitignore = new File(DKUApp.getBaseFolder(), "config/.dku-projects-gitignore");
        if (!globalGitignore.exists()) {
            logger.info((Object)("Creating global projects gitignore file at: " + globalGitignore.getAbsolutePath()));
            try {
                Files.write(globalGitignore.toPath(), Arrays.asList("# Global Dataiku projects gitignore", ".dss-meta"), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to create global projects gitignore file", (Throwable)e);
                throw e;
            }
        }
        logger.info((Object)".dku-projects-gitignore already exists");
        try {
            String content = Files.readString(globalGitignore.toPath());
            String regex = "^" + ".dss-meta".replace(".", "\\.") + "$";
            Pattern pattern = Pattern.compile(regex, 8);
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) {
                logger.info((Object)"Adding missing .dss-meta to .dku-projects-gitignore");
                Files.write(globalGitignore.toPath(), Arrays.asList(content.trim(), ".dss-meta"), StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to check/update .dss-meta in global projects gitignore file", (Throwable)e);
            throw e;
        }
    }
}

