/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.CommitEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.DSSSingleRepositoryGitManager;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.NamedLock;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DevZoneJGitManager
extends DSSSingleRepositoryGitManager {
    protected static final Logger logger = Logger.getLogger((String)"dku.git.devzone");

    public DevZoneJGitManager(File root) throws IOException {
        super(root);
    }

    protected Git initRepository(File repositoryRoot, @Nullable GitModel.GitAuthor gitAuthor) throws IOException {
        String lockName = JGitManager.getRepositoryLockName((String)repositoryRoot.getAbsolutePath());
        try (AutoCloseableLock ignored = NamedLock.acquire((String)lockName);){
            boolean newGitRepo = !new File(repositoryRoot, ".git").isDirectory();
            Git git = super.initRepositoryNoLock(repositoryRoot, gitAuthor);
            if (newGitRepo) {
                String itemId = this.root.getName();
                DSSCommitDef commitDef = new DSSCommitDef(DSSCommitDef.CommitDefType.GLOBAL, itemId, GitModel.GitAuthor.DATAIKU, String.format("Initialized new Git repository: %s", itemId), (List)Lists.newArrayList((Object[])new String[]{"."}));
                String commitRet = this.basicCommitPatterns(git, this.gitProtectedFiles, commitDef.author, commitDef.message, commitDef.filePatterns);
                try {
                    PubSubService pubSub = (PubSubService)((Object)SpringUtils.getBean(PubSubService.class));
                    pubSub.publish(new CommitEvent(commitDef.message, commitDef.itemId, commitDef.author, commitRet));
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
            Git git2 = git;
            return git2;
        }
    }

    @Override
    protected String getPath(String id) {
        return id;
    }
}

