/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class MesMonitoringStatus {
    public String mesName;
    public String id;
    public Long timestamp;
    @Nullable
    public Long latestCheckTimestamp;
    public Map<String, CheckInfo> successes = new HashMap<String, CheckInfo>();
    public Map<String, CheckInfo> warnings = new HashMap<String, CheckInfo>();
    public Map<String, CheckInfo> errors = new HashMap<String, CheckInfo>();

    public static MesMonitoringStatus readMonitoringStatus(File monitoringStatusFile) throws IOException {
        MesMonitoringStatus ret = (MesMonitoringStatus)JSON.parseFile((File)monitoringStatusFile, MesMonitoringStatus.class);
        ret.id = monitoringStatusFile.getName().replace(".json", "");
        return ret;
    }

    public MesMonitoringStatus(String id) {
        this.id = id;
    }

    public Long computeLatestCheckTimestamp() {
        return Stream.of(this.successes, this.warnings, this.errors).flatMap(m -> m.values().stream()).map(info -> info.timestamp).max(Long::compareTo).orElse(null);
    }

    public void applyCheckResults(Map<String, AbstractCheckContext.CheckResult> checkResults, Long mesUpdateTimestamp) {
        checkResults.forEach((checkLabel, checkResult) -> {
            this.successes.remove(checkLabel);
            this.warnings.remove(checkLabel);
            this.errors.remove(checkLabel);
            CheckInfo checkInfo = new CheckInfo(checkResult.message, mesUpdateTimestamp, false);
            switch (checkResult.outcome) {
                case OK: {
                    this.successes.put((String)checkLabel, checkInfo);
                    break;
                }
                case WARNING: {
                    this.warnings.put((String)checkLabel, checkInfo);
                    break;
                }
                case ERROR: {
                    this.errors.put((String)checkLabel, checkInfo);
                    break;
                }
            }
        });
        this.latestCheckTimestamp = this.computeLatestCheckTimestamp();
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isEmpty() {
        return this.successes.isEmpty() && this.warnings.isEmpty() && this.errors.isEmpty();
    }

    public static class CheckInfo {
        public String message;
        public Long timestamp;
        public boolean hasMoreRecentRunOnDifferentSMV;

        public CheckInfo(String message, Long timestamp, boolean hasMoreRecentRunOnDifferentSMV) {
            this.message = message;
            this.timestamp = timestamp;
            this.hasMoreRecentRunOnDifferentSMV = hasMoreRecentRunOnDifferentSMV;
        }
    }
}

