/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.alerting;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyColumnFactory;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyRowObservation;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.savedmodels.externalmodelidentifier.ExternalEndpointIdentifier;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringDeployedProjectComputationTaskCompletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.unifiedmonitoring.AbstractMonitoredThing;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertCRUDService;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertConfig;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertReporter;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertReporterRunner;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertRunsInfo;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertType;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.ManagedEndpointIdentifier;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.scoring.util.RawObservation;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringAlertingService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private NodesService nodesService;
    @Autowired
    private UnifiedMonitoringAlertCRUDService unifiedMonitoringAlertCRUDService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.alerting");

    @PostConstruct
    public void init() {
        try {
            if (!this.nodesService.isOrHasLocalDeployer()) {
                logger.info((Object)"Node has no local deployer enable. Not initializing Unified Monitoring alerting service.");
                return;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"UnifiedMonitoringAlertingService could not be initialized properly", (Throwable)e);
        }
        this.pubSubService.subscribe("unified-monitoring-managed-api-endpoint-snapshot-computation-completed", this::handleUnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent);
        this.pubSubService.subscribe("unified-monitoring-external-api-endpoint-snapshot-computation-completed", this::handleUnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent);
        this.pubSubService.subscribe("unified-monitoring-deployed-project-snapshot-computation-completed", this::handleUnifiedMonitoringDeployedProjectComputationTaskCompletedEvent);
    }

    public void handleUnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent(UnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent event) throws Exception {
        List<UnifiedMonitoringAlertConfig> alertConfigs = this.unifiedMonitoringAlertCRUDService.listAlertConfigs(event.infrastructureId, UnifiedMonitoringAlertType.MANAGED_ENDPOINT);
        for (ManagedEndpointIdentifier endpointIdentifier : event.newSnapshots.keySet()) {
            MonitoredManagedApiEndpoint newSnapshot = event.newSnapshots.get(endpointIdentifier);
            MonitoredManagedApiEndpoint previousSnapshot = event.previousSnapshots.getOrDefault(endpointIdentifier, null);
            this.triggerAlertsIfNeeded(alertConfigs, previousSnapshot, newSnapshot);
        }
    }

    public void handleUnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent(UnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent event) throws Exception {
        List<UnifiedMonitoringAlertConfig> alertConfigs = this.unifiedMonitoringAlertCRUDService.listAlertConfigs(event.externalEndpointScopeName, UnifiedMonitoringAlertType.EXTERNAL_ENDPOINT);
        for (ExternalEndpointIdentifier endpointIdentifier : event.newSnapshots.keySet()) {
            MonitoredExternalApiEndpoint newSnapshot = event.newSnapshots.get(endpointIdentifier);
            MonitoredExternalApiEndpoint previousSnapshot = event.previousSnapshots.getOrDefault(endpointIdentifier, null);
            this.triggerAlertsIfNeeded(alertConfigs, previousSnapshot, newSnapshot);
        }
    }

    public void handleUnifiedMonitoringDeployedProjectComputationTaskCompletedEvent(UnifiedMonitoringDeployedProjectComputationTaskCompletedEvent event) throws Exception {
        List<UnifiedMonitoringAlertConfig> alertConfigs = this.unifiedMonitoringAlertCRUDService.listAlertConfigs(event.infrastructureId, UnifiedMonitoringAlertType.PROJECT);
        for (String deploymentId : event.newSnapshots.keySet()) {
            AbstractMonitoredProjectDeployment newSnapshot = event.newSnapshots.get(deploymentId);
            AbstractMonitoredProjectDeployment previousSnapshot = event.previousSnapshots.getOrDefault(deploymentId, null);
            this.triggerAlertsIfNeeded(alertConfigs, previousSnapshot, newSnapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerAlertsIfNeeded(List<UnifiedMonitoringAlertConfig> alertConfigs, AbstractMonitoredThing previousSnapshot, AbstractMonitoredThing newSnapshot) throws IOException {
        for (UnifiedMonitoringAlertConfig alertConfig : alertConfigs) {
            UnifiedMonitoringAlertRunsInfo runsInfo = new UnifiedMonitoringAlertRunsInfo(alertConfig.id);
            runsInfo.lastRunTimestamp = DateTime.now().getMillis();
            AtomicBoolean lastRunHasErrors = new AtomicBoolean(false);
            try (DKUExecutors.DKUExecutor executor = new DKUExecutors.DKUExecutor(DKUApp.getProperty((String)"dku.deployer.umAlerting.threadPoolSize", (int)10), "umAlertingExecutor", "umAlerting-%d", 1000);){
                if (!alertConfig.isActive || !this.matchesFilter(newSnapshot, alertConfig.filter) || !this.matchesTriggerConditions(previousSnapshot, newSnapshot, alertConfig.triggerConditions)) continue;
                for (UnifiedMonitoringAlertReporter reporter : alertConfig.reporters) {
                    executor.submit(() -> {
                        UnifiedMonitoringAlertReporterRunner reporterRunner = new UnifiedMonitoringAlertReporterRunner(reporter, alertConfig, newSnapshot, previousSnapshot);
                        try {
                            reporterRunner.sendMessage();
                        }
                        catch (Exception e) {
                            logger.warnV((Throwable)e, "Failure during report of alert %s with reporter %s", new Object[]{alertConfig.name, reporter.name});
                            lastRunHasErrors.set(true);
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "An error happened with the alert configuration %s.", new Object[]{alertConfig.id});
                lastRunHasErrors.set(true);
            }
            finally {
                runsInfo.lastRunHasErrors = lastRunHasErrors.get();
                this.unifiedMonitoringAlertCRUDService.saveAlertRunsInfo(runsInfo);
            }
        }
    }

    @VisibleForTesting
    boolean matchesFilter(AbstractMonitoredThing snapshot, FilterDesc filter) {
        Expression expression;
        if (filter == null || !filter.enabled) {
            return true;
        }
        HashMap<Object, Object> observationMap = new HashMap();
        if (snapshot instanceof MonitoredManagedApiEndpoint) {
            MonitoredManagedApiEndpoint managedEndpointSnapshot = (MonitoredManagedApiEndpoint)snapshot;
            observationMap = new HashMap<String, List>(Map.of("displayName", MoreObjects.firstNonNull((Object)managedEndpointSnapshot.displayedName, (Object)""), "endpointName", MoreObjects.firstNonNull((Object)managedEndpointSnapshot.endpointName, (Object)""), "deploymentId", MoreObjects.firstNonNull((Object)managedEndpointSnapshot.deploymentId, (Object)""), "tags", managedEndpointSnapshot.tags, "aiTypes", managedEndpointSnapshot.typeBadges));
        } else if (snapshot instanceof MonitoredExternalApiEndpoint) {
            MonitoredExternalApiEndpoint externalEndpointSnapshot = (MonitoredExternalApiEndpoint)snapshot;
            observationMap = new HashMap<String, String>(Map.of("endpointName", (String)MoreObjects.firstNonNull((Object)externalEndpointSnapshot.endpointName, (Object)"")));
        } else if (snapshot instanceof AbstractMonitoredProjectDeployment) {
            AbstractMonitoredProjectDeployment projectSnapshot = (AbstractMonitoredProjectDeployment)snapshot;
            observationMap = new HashMap<String, List>(Map.of("displayName", MoreObjects.firstNonNull((Object)projectSnapshot.displayedName, (Object)""), "deploymentId", MoreObjects.firstNonNull((Object)projectSnapshot.deploymentId, (Object)""), "deployedProjectKey", MoreObjects.firstNonNull((Object)projectSnapshot.deployedProjectKey, (Object)""), "bundleName", MoreObjects.firstNonNull((Object)projectSnapshot.bundleName, (Object)""), "tags", projectSnapshot.tags, "aiTypes", projectSnapshot.typeBadges));
        }
        RawObservation observation = new RawObservation(observationMap);
        try {
            expression = new Expression(FilterDescUtils.getGrelExpression(filter));
            expression.setColumnFactory((ColumnFactory)new ReadOnlyColumnFactory(observation.keys().toArray(new String[0])));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return expression.isTrueish(new ReadOnlyRowObservation(observation));
    }

    @VisibleForTesting
    boolean matchesTriggerConditions(@Nullable AbstractMonitoredThing previousSnapshot, AbstractMonitoredThing newSnapshot, FilterDesc triggerConditions) {
        Expression expression;
        if (triggerConditions == null || !triggerConditions.enabled) {
            throw new IllegalStateException("You must enable trigger conditions on your alert configuration");
        }
        HashMap<Object, Object> observationMap = new HashMap();
        if (newSnapshot instanceof MonitoredManagedApiEndpoint) {
            MonitoredManagedApiEndpoint newEndpointSnapshot = (MonitoredManagedApiEndpoint)newSnapshot;
            observationMap = new HashMap<String, String>(Map.of("deploymentStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "modelStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "governanceStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umGovernanceStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "globalStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString())));
            if (previousSnapshot instanceof MonitoredManagedApiEndpoint) {
                MonitoredManagedApiEndpoint previousEndpointSnapshot = (MonitoredManagedApiEndpoint)previousSnapshot;
                observationMap.put("deploymentStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("modelStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("governanceStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umGovernanceStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("globalStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
            }
        } else if (newSnapshot instanceof MonitoredExternalApiEndpoint) {
            MonitoredExternalApiEndpoint newEndpointSnapshot = (MonitoredExternalApiEndpoint)newSnapshot;
            observationMap = new HashMap<String, String>(Map.of("deploymentStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "modelStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "globalStatus_cur", (String)MoreObjects.firstNonNull((Object)newEndpointSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString())));
            if (previousSnapshot instanceof MonitoredExternalApiEndpoint) {
                MonitoredExternalApiEndpoint previousEndpointSnapshot = (MonitoredExternalApiEndpoint)previousSnapshot;
                observationMap.put("deploymentStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("modelStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("globalStatus_prev", MoreObjects.firstNonNull((Object)previousEndpointSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
            }
        } else if (newSnapshot instanceof AbstractMonitoredProjectDeployment) {
            AbstractMonitoredProjectDeployment newProjectSnapshot = (AbstractMonitoredProjectDeployment)newSnapshot;
            observationMap = new HashMap<String, String>(Map.of("deploymentStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "modelStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umProjectModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "executionStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umProjectExecutionStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "dataStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umDataQualityStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "governanceStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umGovernanceStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()), "globalStatus_cur", (String)MoreObjects.firstNonNull((Object)newProjectSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString())));
            if (previousSnapshot instanceof AbstractMonitoredProjectDeployment) {
                AbstractMonitoredProjectDeployment previousProjectSnapshot = (AbstractMonitoredProjectDeployment)previousSnapshot;
                observationMap.put("deploymentStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umDeploymentStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("modelStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umProjectModelStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("executionStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umProjectExecutionStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("dataStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umDataQualityStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("governanceStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umGovernanceStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
                observationMap.put("globalStatus_prev", MoreObjects.firstNonNull((Object)previousProjectSnapshot.umGlobalStatus.toString(), (Object)UnifiedMonitoringStatus.NO_STATUS.toString()));
            }
        }
        RawObservation observation = new RawObservation(observationMap);
        try {
            expression = new Expression(FilterDescUtils.getGrelExpression(triggerConditions));
            expression.setColumnFactory((ColumnFactory)new ReadOnlyColumnFactory(observation.keys().toArray(new String[0])));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return expression.isTrueish(new ReadOnlyRowObservation(observation));
    }

    public UsageSummaryModel.UnifiedMonitoringAlertingReport getReportData() {
        UsageSummaryModel.UnifiedMonitoringAlertingReport report = new UsageSummaryModel.UnifiedMonitoringAlertingReport();
        try {
            List<UnifiedMonitoringAlertConfig> alertConfigsList = this.unifiedMonitoringAlertCRUDService.listAlertConfigs();
            for (UnifiedMonitoringAlertConfig alertConfig : alertConfigsList) {
                report.nbAlertsByType.put(alertConfig.type.name(), report.nbAlertsByType.getOrDefault(alertConfig.type.name(), 0) + 1);
                if (alertConfig.isActive) {
                    report.nbAlertsEnabledOrDisabled.put("ENABLED", report.nbAlertsEnabledOrDisabled.getOrDefault("ENABLED", 0) + 1);
                } else {
                    report.nbAlertsEnabledOrDisabled.put("DISABLED", report.nbAlertsEnabledOrDisabled.getOrDefault("DISABLED", 0) + 1);
                }
                if (alertConfig.isValid) {
                    report.nbAlertsValidOrInvalid.put("VALID", report.nbAlertsValidOrInvalid.getOrDefault("VALID", 0) + 1);
                } else {
                    report.nbAlertsValidOrInvalid.put("INVALID", report.nbAlertsValidOrInvalid.getOrDefault("INVALID", 0) + 1);
                }
                for (UnifiedMonitoringAlertReporter reporter : alertConfig.reporters) {
                    if (reporter.messaging == null) continue;
                    report.nbReportersByType.put(reporter.messaging.getType(), report.nbReportersByType.getOrDefault(reporter.messaging.getType(), 0) + 1);
                }
            }
            return report;
        }
        catch (Exception e) {
            logger.warn((Object)"Could not compute report data for Unified Monitoring Alerting", (Throwable)e);
            return null;
        }
    }
}

