/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.scheduler;

import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiDeploymentSystemMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentUpdatedWithoutErrorsEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraCreatedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringBatchFrequencyChangedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringEndpointInfrastructureDisabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringEndpointInfrastructureEnabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeCreatedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeDeletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeDisabledEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalEndpointsScopeEnabledEvent;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerCRUDService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerService;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.unifiedmonitoring.scheduler.UnifiedMonitoringSnapshotComputationTask;
import com.dataiku.dip.utils.CollectorUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringSchedulerService {
    public static final String UNIFIED_MONITORING_JOB_GROUP_NAME = "unifiedmonitoring";
    public static final String COMPUTE_MANAGED_API_ENDPOINTS_SNAPSHOTS = "compute-managed-api-endpoint-snapshots";
    public static final String COMPUTE_EXTERNAL_ENDPOINTS_SNAPSHOTS = "compute-external-api-endpoint-snapshots";
    public static final String COMPUTE_DEPLOYED_PROJECTS_SNAPSHOTS = "compute-deployed-projects-snapshots";
    public static final String COMPUTE_SYSTEM_METRICS = "compute-system-metrics";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private NodesService nodesService;
    @Autowired
    private UnifiedMonitoringDeployerService unifiedMonitoringDeployerService;
    @Autowired
    private UnifiedMonitoringDeployerCRUDService unifiedMonitoringDeployerCRUDService;
    @Autowired
    private ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;
    @Autowired
    private ApiDeploymentSystemMonitoringService apiDeploymentSystemMonitoringService;
    private Scheduler scheduler;
    private int schedulerDefaultEndpointsBatchFrequencyMinutes;
    private int schedulerProjectsBatchFrequencyMinutes;
    private int schedulerDatabricksBatchFrequencyMinutes;
    private int schedulerSystemMetricsBatchFrequencySeconds;
    private final List<AbstractInfraBasicInfo> infrastructuresScheduledToBeComputed = new ArrayList<AbstractInfraBasicInfo>();
    private final List<UnifiedMonitoringExternalEndpointsScope> externalEndpointsScopesToBeComputed = new ArrayList<UnifiedMonitoringExternalEndpointsScope>();
    private final Consumer<String> deleteActivityRrdsAndSnapshots = deploymentId -> {
        try {
            this.unifiedMonitoringDeployerCRUDService.deleteManagedApiEndpointSnapshots((String)deploymentId);
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Failed to delete activity snapshots for deployment %s", new Object[]{deploymentId});
        }
        this.apiEndpointActivityMonitoringService.deleteActivityRrds((String)deploymentId);
    };
    private final Consumer<String> deleteSystemMetricsRrds = deploymentId -> {
        try {
            this.apiDeploymentSystemMonitoringService.deleteSystemMetricsRrd((String)deploymentId);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to delete system metrics for deployment %s", new Object[]{deploymentId});
        }
    };
    private final BiConsumer<String, String> updateDeploymentMonitoringData = (infrastructureId, deploymentId) -> {
        try {
            AbstractInfraBasicInfo infraBasicInfo = this.getInfraBasicInfo((String)infrastructureId);
            this.unifiedMonitoringDeployerService.updateDeploymentMonitoringData((String)deploymentId, infraBasicInfo.getInfraType());
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to handle update of api deployer deployment %s of infra %s", new Object[]{deploymentId, infrastructureId});
        }
    };
    private final BiConsumer<String, String> deleteProjectSnapshot = (infrastructureId, deploymentId) -> {
        try {
            this.unifiedMonitoringDeployerCRUDService.deleteProjectSnapshot((String)deploymentId);
        }
        catch (Exception e) {
            logger.warnV("Failed to delete monitoring snapshot of project %s for infra %s", new Object[]{deploymentId, infrastructureId});
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.scheduler");

    @PostConstruct
    public void init() {
        try {
            Map monitoredEndpointScopeByNames;
            Map monitoredEndpointInfraByIds;
            Map endpointInfraByIds;
            Map externalEndpointsScopeByNames;
            UnifiedMonitoringSettings unifiedMonitoringSettings;
            if (!this.nodesService.isOrHasLocalDeployer()) {
                logger.info((Object)"Node has no local deployer enable. Not initializing Unified Monitoring computation service.");
                return;
            }
            logger.info((Object)"Initialization of Unified Monitoring computation service scheduler");
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
            try (Transaction t = this.transactionService.beginRead();){
                unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
                unifiedMonitoringSettings.validate();
                this.schedulerDefaultEndpointsBatchFrequencyMinutes = unifiedMonitoringSettings.endpointsBatchFrequencyInMinutes;
                this.schedulerProjectsBatchFrequencyMinutes = unifiedMonitoringSettings.projectsBatchFrequencyInMinutes;
                this.schedulerDatabricksBatchFrequencyMinutes = 1;
                this.schedulerSystemMetricsBatchFrequencySeconds = unifiedMonitoringSettings.systemMetricsBatchFrequencyInSeconds;
                externalEndpointsScopeByNames = unifiedMonitoringSettings.externalEndpointsScopes.stream().collect(Collectors.toMap(s -> s.name, Function.identity()));
                endpointInfraByIds = this.apiNodeInfrasService.listLightStatusUnsafe_Check(DSSAuthCtx.internalAdminAuth()).stream().map(InfraLightStatus::getInfraBasicInfo).collect(Collectors.toMap(AbstractInfraBasicInfo::getId, Function.identity()));
            }
            this.addScheduledTaskMinutes(UnifiedMonitoringSnapshotComputationTask.DeployedProjectsStatuses.class, this.getDeployedProjectSnapshotComputationJobKey(), this.schedulerDefaultEndpointsBatchFrequencyMinutes, new HashMap<String, String>());
            List<String> unmonitoredEndpointInfras = unifiedMonitoringSettings.unmonitoredEndpointInfrastructures;
            if (!unmonitoredEndpointInfras.isEmpty()) {
                logger.infoV("Monitoring of the following endpoint infrastructures is disabled : %s", new Object[]{unmonitoredEndpointInfras.toString()});
            }
            if ((monitoredEndpointInfraByIds = (Map)endpointInfraByIds.entrySet().stream().filter(entry -> !unmonitoredEndpointInfras.contains(entry.getKey())).collect(CollectorUtils.toMap())).isEmpty()) {
                logger.info((Object)"There are no API endpoints infrastructures to monitor for Unified Monitoring - not creating scheduled tasks");
            } else {
                logger.infoV("Creating scheduled tasks for monitoring endpoints of deployment infrastructure : %s", new Object[]{monitoredEndpointInfraByIds.keySet().toString()});
                for (Map.Entry idAndInfra : monitoredEndpointInfraByIds.entrySet()) {
                    this.scheduleInfraApiEndpointSnapshotComputation((String)idAndInfra.getKey(), (AbstractInfraBasicInfo)idAndInfra.getValue());
                    if (!this.apiNodeInfrasService.hasSystemMetrics((AbstractInfraBasicInfo)idAndInfra.getValue())) continue;
                    this.scheduleInfraSystemMetricsComputation((String)idAndInfra.getKey());
                }
            }
            List<String> unmonitoredEndpointScopeNames = unifiedMonitoringSettings.unmonitoredExternalEndpointsScopes;
            if (!unmonitoredEndpointScopeNames.isEmpty()) {
                logger.infoV("Monitoring of the following endpoint scopes is disabled : %s", new Object[]{unmonitoredEndpointScopeNames.toString()});
            }
            if ((monitoredEndpointScopeByNames = (Map)externalEndpointsScopeByNames.entrySet().stream().filter(entry -> !unmonitoredEndpointScopeNames.contains(entry.getKey())).collect(CollectorUtils.toMap())).isEmpty()) {
                logger.info((Object)"No external endpoint monitoring scopes defined or enabled - not creating scheduled tasks");
            } else {
                logger.infoV("Creation of scheduled tasks for Unified Monitoring computation external endpoint scopes :%s", new Object[]{monitoredEndpointScopeByNames.keySet()});
                for (Map.Entry nameAndScope : monitoredEndpointScopeByNames.entrySet()) {
                    this.scheduleExternalEndpointsScopeSnapshotComputation((String)nameAndScope.getKey(), (UnifiedMonitoringExternalEndpointsScope)nameAndScope.getValue());
                }
            }
            this.pubSubService.subscribe("apideployer-infra-created", this::handleAPIDeployerInfraCreated);
            this.pubSubService.subscribe("apideployer-infra-deleted", this::handleAPIDeployerInfraDeleted);
            this.pubSubService.subscribe("unified-monitoring-endpoint-infrastructure-enabled", this::handleUnifiedMonitoringEndpointInfrastructureEnabled);
            this.pubSubService.subscribe("unified-monitoring-endpoint-infrastructure-disabled", this::handleUnifiedMonitoringEndpointInfrastructureDisabled);
            this.pubSubService.subscribe("apideployer-deployment-deleted", this::handleAPIDeployerDeploymentDeleted);
            this.pubSubService.subscribe("apideployer-deployment-updated_without-errors", this::handleAPIDeployerDeploymentUpdatedWithoutErrorsEvent);
            this.pubSubService.subscribe("unified-monitoring-external-endpoints-scope-created", this::handleUnifiedMonitoringExternalEndpointsScopeCreated);
            this.pubSubService.subscribe("unified-monitoring-external-endpoints-scope-deleted", this::handleUnifiedMonitoringExternalEndpointsScopeDeleted);
            this.pubSubService.subscribe("unified-monitoring-external-endpoints-scope-enabled", this::handleUnifiedMonitoringExternalEndpointsScopeEnabled);
            this.pubSubService.subscribe("unified-monitoring-external-endpoint-scope-disabled", this::handleUnifiedMonitoringExternalEndpointScopeDisabled);
            this.pubSubService.subscribe("projectdeployer-deployment-deleted", this::handleProjectDeployerDeploymentDeleted);
            this.pubSubService.subscribe("unified-monitoring-projects-batch-frequency-modified", this::handleUnifiedMonitoringProjectsBatchFrequencyChanged);
            this.pubSubService.subscribe("unified-monitoring-endpoints-batch-frequency-modified", this::handleUnifiedMonitoringEndpointsBatchFrequencyChanged);
            this.pubSubService.subscribe("unified-monitoring-system-metrics-batch-frequency-modified", this::handleUnifiedMonitoringSystemMetricsBatchFrequencyChanged);
        }
        catch (Exception e) {
            logger.fatal((Object)"UnifiedMonitoringSchedulerService could not be initialized properly", (Throwable)e);
        }
    }

    private int getSchedulerEndpointsBatchFrequencyMinutes(@Nullable AbstractInfraBasicInfo infra) {
        if (infra == null) {
            return this.schedulerDefaultEndpointsBatchFrequencyMinutes;
        }
        if (AbstractDeploymentInfra.InfraType.DATABRICKS.equals((Object)infra.getInfraType())) {
            return this.schedulerDatabricksBatchFrequencyMinutes;
        }
        return this.schedulerDefaultEndpointsBatchFrequencyMinutes;
    }

    private int getSchedulerEndpointsBatchFrequencyMinutes(@Nullable UnifiedMonitoringExternalEndpointsScope scope) {
        if (scope == null) {
            return this.schedulerDefaultEndpointsBatchFrequencyMinutes;
        }
        if ("DatabricksModelDeployment".equals(scope.getType())) {
            return this.schedulerDatabricksBatchFrequencyMinutes;
        }
        return this.schedulerDefaultEndpointsBatchFrequencyMinutes;
    }

    private void addScheduledTaskMinutes(Class<? extends Job> clazz, JobKey jobKey, int frequencyInMinutes, Map<String, String> jobData) throws SchedulerException {
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.repeatMinutelyForever((int)frequencyInMinutes).withMisfireHandlingInstructionFireNow();
        Date startAt = DateBuilder.futureDate((int)frequencyInMinutes, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE);
        this.addScheduledTask(clazz, jobKey, (ScheduleBuilder<?>)scheduleBuilder, startAt, jobData);
    }

    private void addScheduledTaskSeconds(Class<? extends Job> clazz, JobKey jobKey, int frequencyInSeconds, Map<String, String> jobData) throws SchedulerException {
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.repeatSecondlyForever((int)frequencyInSeconds).withMisfireHandlingInstructionFireNow();
        Date startAt = DateBuilder.futureDate((int)frequencyInSeconds, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND);
        this.addScheduledTask(clazz, jobKey, (ScheduleBuilder<?>)scheduleBuilder, startAt, jobData);
    }

    private void addScheduledTask(Class<? extends Job> clazz, JobKey jobKey, ScheduleBuilder<?> scheduleBuilder, Date startAt, Map<String, String> jobData) throws SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(clazz).withIdentity(jobKey);
        jobData.forEach((arg_0, arg_1) -> ((JobBuilder)jobBuilder).usingJobData(arg_0, arg_1));
        JobDetail job = jobBuilder.build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName() + "-trigger", UNIFIED_MONITORING_JOB_GROUP_NAME).withSchedule(scheduleBuilder).startAt(startAt).build();
        this.scheduler.scheduleJob(job, trigger);
        this.scheduler.triggerJob(job.getKey(), job.getJobDataMap());
        logger.info((Object)("Scheduled task successfully added : " + job.getKey().toString()));
    }

    private void reschedule(String jobName, int frequency, DateBuilder.IntervalUnit intervalUnit) throws SchedulerException {
        assert (intervalUnit == DateBuilder.IntervalUnit.MINUTE || intervalUnit == DateBuilder.IntervalUnit.SECOND) : String.format("Unsupported interval unit %s", intervalUnit);
        String intervalUnitString = String.format("%ss", intervalUnit.toString().toLowerCase());
        logger.infoV("Rescheduling job %s with %s %s frequency", new Object[]{jobName, frequency, intervalUnitString});
        TriggerKey triggerKey = this.getTriggerKey(jobName);
        Trigger newTrigger = this.getTrigger(triggerKey, frequency, intervalUnit);
        this.scheduler.rescheduleJob(triggerKey, newTrigger);
    }

    private TriggerKey getTriggerKey(String jobName) {
        return new TriggerKey(jobName + "-trigger", UNIFIED_MONITORING_JOB_GROUP_NAME);
    }

    private Trigger getTrigger(TriggerKey triggerKey, int frequency, DateBuilder.IntervalUnit intervalUnit) {
        return TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)(switch (intervalUnit) {
            case DateBuilder.IntervalUnit.MINUTE -> SimpleScheduleBuilder.repeatMinutelyForever((int)frequency);
            case DateBuilder.IntervalUnit.SECOND -> SimpleScheduleBuilder.repeatSecondlyForever((int)frequency);
            default -> throw ErrorContext.iaef((String)"Unsupported interval unit %s", (Object)intervalUnit, (Object[])new Object[0]);
        })).build();
    }

    private void deleteScheduledInfraApiEndpointSnapshotComputation(String infrastructureId) throws SchedulerException {
        logger.infoV("Deleting scheduled api endpoints computation for infra %s", new Object[]{infrastructureId});
        JobKey infraSnapshotComputationJobKey = this.getInfraSnapshotComputationJobKey(infrastructureId);
        this.scheduler.deleteJob(infraSnapshotComputationJobKey);
        this.infrastructuresScheduledToBeComputed.removeIf(i -> i.getId().equals(infrastructureId));
    }

    private void deleteScheduledInfraApiEndpointSystemMetricsComputation(String infrastructureId) throws IOException, SchedulerException {
        logger.infoV("Deleting scheduled system metrics computation for infra %s", new Object[]{infrastructureId});
        JobKey infraSystemMetricsComputationJobKey = this.getInfraSystemMetricsComputationJobKey(infrastructureId);
        this.scheduler.deleteJob(infraSystemMetricsComputationJobKey);
    }

    private void deleteScheduledExternalEndpointsScopeComputation(String externalEndpointsScopeName) throws SchedulerException {
        logger.infoV("Deleting scheduled external endpoints computation for scope %s", new Object[]{externalEndpointsScopeName});
        JobKey jobKey = this.getExternalEndpointsScopeSnapshotComputationJobKey(externalEndpointsScopeName);
        try {
            if (this.scheduler.interrupt(jobKey)) {
                logger.info((Object)"Scheduled task %s was successfully interrupted.");
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "An error occurred during the interruption of %s", new Object[]{jobKey.toString()});
        }
        this.scheduler.deleteJob(jobKey);
        this.externalEndpointsScopesToBeComputed.removeIf(s -> s.name.equals(externalEndpointsScopeName));
    }

    private JobKey getInfraSnapshotComputationJobKey(String infrastructureId) {
        return new JobKey("compute-managed-api-endpoint-snapshots-" + infrastructureId, UNIFIED_MONITORING_JOB_GROUP_NAME);
    }

    private JobKey getInfraSystemMetricsComputationJobKey(String infrastructureId) {
        return new JobKey(String.format("%s-%s", COMPUTE_SYSTEM_METRICS, infrastructureId), UNIFIED_MONITORING_JOB_GROUP_NAME);
    }

    private JobKey getExternalEndpointsScopeSnapshotComputationJobKey(String externalEndpointsScopeName) {
        return new JobKey("compute-external-api-endpoint-snapshots-" + externalEndpointsScopeName, UNIFIED_MONITORING_JOB_GROUP_NAME);
    }

    private JobKey getDeployedProjectSnapshotComputationJobKey() {
        return new JobKey(COMPUTE_DEPLOYED_PROJECTS_SNAPSHOTS, UNIFIED_MONITORING_JOB_GROUP_NAME);
    }

    private void handleAPIDeployerInfraCreated(APIDeployerInfraCreatedEvent event) throws SchedulerException, IOException, UnauthorizedException {
        AbstractInfraBasicInfo infra = this.getInfraBasicInfo(event.infrastructureId);
        if (infra == null) {
            logger.warnV("Could not find infrastructure %s", new Object[]{event.infrastructureId});
            return;
        }
        this.scheduleInfraComputations(infra);
    }

    private void handleUnifiedMonitoringEndpointInfrastructureEnabled(UnifiedMonitoringEndpointInfrastructureEnabledEvent event) throws SchedulerException, IOException, UnauthorizedException {
        AbstractInfraBasicInfo infra = this.getInfraBasicInfo(event.infrastructureId);
        if (infra == null) {
            logger.warnV("Could not find infrastructure %s", new Object[]{event.infrastructureId});
            return;
        }
        this.scheduleInfraComputations(infra);
    }

    private void handleAPIDeployerInfraDeleted(APIDeployerInfraDeletedEvent event) {
        try {
            this.deleteScheduledInfraApiEndpointSnapshotComputation(event.infrastructureId);
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to delete api endpoint snapshot monitoring for infra %s", new Object[]{event.infrastructureId});
        }
        if (!this.apiNodeInfrasService.hasSystemMetrics(event.infraType)) {
            return;
        }
        try {
            this.deleteScheduledInfraApiEndpointSystemMetricsComputation(event.infrastructureId);
        }
        catch (IOException | SchedulerException e) {
            logger.warnV(e, "Failed to delete api endpoint system metrics monitoring for infra %s", new Object[]{event.infrastructureId});
        }
    }

    private void handleUnifiedMonitoringEndpointInfrastructureDisabled(UnifiedMonitoringEndpointInfrastructureDisabledEvent event) {
        try {
            this.deleteScheduledInfraApiEndpointSnapshotComputation(event.infrastructureId);
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to unschedule api endpoint snapshot monitoring for infra %s", new Object[]{event.infrastructureId});
        }
        if (!this.apiNodeInfrasService.hasSystemMetrics(DSSAuthCtx.internalAdminAuth(), event.infrastructureId)) {
            return;
        }
        try {
            this.deleteScheduledInfraApiEndpointSystemMetricsComputation(event.infrastructureId);
        }
        catch (IOException | SchedulerException e) {
            logger.warnV(e, "Failed to unschedule api endpoint system metrics monitoring for infra %s", new Object[]{event.infrastructureId});
        }
    }

    private void handleAPIDeployerDeploymentDeleted(APIDeployerDeploymentDeletedEvent event) {
        logger.infoV("Handling deletion of api deployer deployment %s of infra %s", new Object[]{event.deploymentId, event.infrastructureId});
        JobKey snapshotJobKey = this.getInfraSnapshotComputationJobKey(event.infrastructureId);
        this.interruptAndResumeJobForDataCleanup(snapshotJobKey, () -> this.deleteActivityRrdsAndSnapshots.accept(event.deploymentId));
        if (!this.apiNodeInfrasService.hasSystemMetrics(DSSAuthCtx.internalAdminAuth(), event.infrastructureId)) {
            return;
        }
        JobKey systemMetricsJobKey = this.getInfraSystemMetricsComputationJobKey(event.infrastructureId);
        this.interruptAndResumeJobForDataCleanup(systemMetricsJobKey, () -> this.deleteSystemMetricsRrds.accept(event.deploymentId));
    }

    private void handleAPIDeployerDeploymentUpdatedWithoutErrorsEvent(APIDeployerDeploymentUpdatedWithoutErrorsEvent event) {
        logger.infoV("Handling update of api deployer deployment %s of infra %s", new Object[]{event.deploymentId, event.infrastructureId});
        JobKey snapshotJobKey = this.getInfraSnapshotComputationJobKey(event.infrastructureId);
        this.interruptAndResumeJobForDataCleanup(snapshotJobKey, () -> this.updateDeploymentMonitoringData.accept(event.infrastructureId, event.deploymentId));
    }

    private void handleProjectDeployerDeploymentDeleted(ProjectDeployerDeploymentDeletedEvent event) {
        logger.infoV("Deleting monitoring snapshot of project %s for infra %s", new Object[]{event.deploymentId, event.infrastructureId});
        JobKey jobKey = this.getDeployedProjectSnapshotComputationJobKey();
        this.interruptAndResumeJobForDataCleanup(jobKey, () -> this.deleteProjectSnapshot.accept(event.infrastructureId, event.deploymentId));
    }

    private void handleUnifiedMonitoringEndpointsBatchFrequencyChanged(UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringEndpointsBatchFrequencyChangedEvent event) {
        int settingsDefaultEndpointsBatchFrequency = event.endpointsBatchFrequencyInMinutes;
        if (settingsDefaultEndpointsBatchFrequency != this.schedulerDefaultEndpointsBatchFrequencyMinutes) {
            try {
                int frequency;
                this.schedulerDefaultEndpointsBatchFrequencyMinutes = settingsDefaultEndpointsBatchFrequency;
                logger.infoV("Unified monitoring : new endpoints batch frequency has been detected : %s", new Object[]{settingsDefaultEndpointsBatchFrequency});
                for (AbstractInfraBasicInfo infrastructure : this.infrastructuresScheduledToBeComputed) {
                    frequency = this.getSchedulerEndpointsBatchFrequencyMinutes(infrastructure);
                    this.rescheduleInfraApiEndpointsComputation(infrastructure.getId(), frequency);
                }
                for (UnifiedMonitoringExternalEndpointsScope externalEndpointsScope : this.externalEndpointsScopesToBeComputed) {
                    frequency = this.getSchedulerEndpointsBatchFrequencyMinutes(externalEndpointsScope);
                    this.rescheduleExternalEndpointsScopeComputation(externalEndpointsScope.name, frequency);
                }
                logger.infoV("The Unified Monitoring endpoints-related scheduled tasks will be now run every %s minutes", new Object[]{settingsDefaultEndpointsBatchFrequency});
            }
            catch (SchedulerException e) {
                logger.warnV((Throwable)e, "Failed to reschedule endpoints deployment snapshot monitoring after a change of frequency.", new Object[0]);
            }
        }
    }

    private void handleUnifiedMonitoringSystemMetricsBatchFrequencyChanged(UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringSystemMetricsBatchFrequencyChangedEvent event) {
        int settingsBatchFrequencyInSeconds = event.systemMetricsBatchFrequencyInSeconds;
        if (settingsBatchFrequencyInSeconds == this.schedulerSystemMetricsBatchFrequencySeconds) {
            return;
        }
        try {
            this.schedulerSystemMetricsBatchFrequencySeconds = settingsBatchFrequencyInSeconds;
            logger.infoV("Unified monitoring : new system metrics batch frequency has been detected : %s", new Object[]{settingsBatchFrequencyInSeconds});
            for (AbstractInfraBasicInfo infrastructure : this.infrastructuresScheduledToBeComputed) {
                if (!this.apiNodeInfrasService.hasSystemMetrics(infrastructure)) continue;
                this.rescheduleInfraSystemMetricsComputation(infrastructure.getId(), settingsBatchFrequencyInSeconds);
            }
            logger.infoV("The Unified Monitoring system metrics-related scheduled tasks will be now run every %s seconds", new Object[]{settingsBatchFrequencyInSeconds});
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to reschedule system metric monitoring tasks after a change of frequency.", new Object[0]);
        }
    }

    private void handleUnifiedMonitoringProjectsBatchFrequencyChanged(UnifiedMonitoringBatchFrequencyChangedEvent.UnifiedMonitoringProjectsBatchFrequencyChangedEvent event) {
        int settingsProjectsBatchFrequency = event.projectsBatchFrequencyInMinutes;
        if (settingsProjectsBatchFrequency != this.schedulerProjectsBatchFrequencyMinutes) {
            try {
                logger.infoV("Unified monitoring : new projects batch frequency has been detected : %s", new Object[]{settingsProjectsBatchFrequency});
                this.rescheduleDeployedProjectComputation(settingsProjectsBatchFrequency);
                this.schedulerProjectsBatchFrequencyMinutes = settingsProjectsBatchFrequency;
                logger.infoV("The Unified Monitoring projects-related scheduled task will be now run every %s minutes", new Object[]{settingsProjectsBatchFrequency});
            }
            catch (SchedulerException e) {
                logger.warnV((Throwable)e, "Failed to reschedule projects deployment snapshot monitoring after a change of frequency.", new Object[0]);
            }
        }
    }

    private void handleUnifiedMonitoringExternalEndpointsScopeCreated(UnifiedMonitoringExternalEndpointsScopeCreatedEvent event) throws SchedulerException, IOException {
        UnifiedMonitoringExternalEndpointsScope scope = this.getScopeNamed_NT(event.externalEndpointsScopeName);
        this.scheduleExternalEndpointsScopeSnapshotComputation(event.externalEndpointsScopeName, scope);
    }

    private void handleUnifiedMonitoringExternalEndpointsScopeEnabled(UnifiedMonitoringExternalEndpointsScopeEnabledEvent event) throws SchedulerException, IOException {
        UnifiedMonitoringExternalEndpointsScope scope = this.getScopeNamed_NT(event.externalEndpointsScopeName);
        this.scheduleExternalEndpointsScopeSnapshotComputation(event.externalEndpointsScopeName, scope);
    }

    private void scheduleInfraComputations(AbstractInfraBasicInfo infraBasicInfo) throws SchedulerException {
        this.scheduleInfraApiEndpointSnapshotComputation(infraBasicInfo.getId(), infraBasicInfo);
        if (this.apiNodeInfrasService.hasSystemMetrics(infraBasicInfo)) {
            this.scheduleInfraSystemMetricsComputation(infraBasicInfo.getId());
        }
    }

    @Nullable
    private UnifiedMonitoringExternalEndpointsScope getScopeNamed_NT(String scopeName) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
            UnifiedMonitoringExternalEndpointsScope unifiedMonitoringExternalEndpointsScope = unifiedMonitoringSettings.externalEndpointsScopes.stream().filter(s -> s.name.equals(scopeName)).findFirst().orElse(null);
            return unifiedMonitoringExternalEndpointsScope;
        }
    }

    private void handleUnifiedMonitoringExternalEndpointsScopeDeleted(UnifiedMonitoringExternalEndpointsScopeDeletedEvent event) {
        try {
            logger.infoV("Deleting scheduled external endpoints computation for scope %s, cleaning up snapshots and rrd files", new Object[]{event.externalEndpointsScopeName});
            this.deleteScheduledExternalEndpointsScopeComputation(event.externalEndpointsScopeName);
            this.unifiedMonitoringDeployerService.deleteExternalEndpointScope(event.externalEndpointsScopeName);
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to delete external endpoints snapshot monitoring for scope %s", new Object[]{event.externalEndpointsScopeName});
        }
    }

    private void handleUnifiedMonitoringExternalEndpointScopeDisabled(UnifiedMonitoringExternalEndpointsScopeDisabledEvent event) {
        try {
            this.deleteScheduledExternalEndpointsScopeComputation(event.externalEndpointsScopeName);
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to unschedule external endpoints snapshot monitoring for scope %s", new Object[]{event.externalEndpointsScopeName});
        }
    }

    private void rescheduleDeployedProjectComputation(int batchFrequencyInMinutes) throws SchedulerException {
        logger.infoV("Rescheduling deployed project computation with %s minutes frequency", new Object[]{batchFrequencyInMinutes});
        JobKey jobKey = this.getDeployedProjectSnapshotComputationJobKey();
        this.reschedule(jobKey.getName(), batchFrequencyInMinutes, DateBuilder.IntervalUnit.MINUTE);
    }

    private void rescheduleInfraApiEndpointsComputation(String infrastructureId, int batchFrequencyInMinutes) throws SchedulerException {
        logger.infoV("Rescheduling api endpoints computation for infra %s computation with %s minutes frequency", new Object[]{infrastructureId, batchFrequencyInMinutes});
        JobKey jobKey = this.getInfraSnapshotComputationJobKey(infrastructureId);
        this.reschedule(jobKey.getName(), batchFrequencyInMinutes, DateBuilder.IntervalUnit.MINUTE);
    }

    private void rescheduleInfraSystemMetricsComputation(String infrastructureId, int batchFrequencyInSeconds) throws SchedulerException {
        logger.infoV("Rescheduling system metrics computation for infra %s with %s seconds frequency", new Object[]{infrastructureId, batchFrequencyInSeconds});
        JobKey jobKey = this.getInfraSystemMetricsComputationJobKey(infrastructureId);
        this.reschedule(jobKey.getName(), batchFrequencyInSeconds, DateBuilder.IntervalUnit.SECOND);
    }

    private void rescheduleExternalEndpointsScopeComputation(String externalEndpointsScopeName, int batchFrequencyInMinutes) throws SchedulerException {
        logger.infoV("Rescheduling external endpoints computation for external endpoint scope %s computation with %s minutes frequency", new Object[]{externalEndpointsScopeName, batchFrequencyInMinutes});
        JobKey jobKey = this.getExternalEndpointsScopeSnapshotComputationJobKey(externalEndpointsScopeName);
        this.reschedule(jobKey.getName(), batchFrequencyInMinutes, DateBuilder.IntervalUnit.MINUTE);
    }

    private void scheduleInfraApiEndpointSnapshotComputation(String infrastructureId, AbstractInfraBasicInfo infraBasicInfo) throws SchedulerException {
        int frequency = this.getSchedulerEndpointsBatchFrequencyMinutes(infraBasicInfo);
        logger.infoV("Scheduling api endpoints computation for infra %s with %s minutes frequency", new Object[]{infrastructureId, frequency});
        HashMap<String, String> jobData = new HashMap<String, String>();
        jobData.put("infrastructureId", infrastructureId);
        this.addScheduledTaskMinutes(UnifiedMonitoringSnapshotComputationTask.ApiEndpointStatusesAndActivityMetrics.class, this.getInfraSnapshotComputationJobKey(infrastructureId), frequency, jobData);
        this.infrastructuresScheduledToBeComputed.add(infraBasicInfo);
    }

    private void scheduleInfraSystemMetricsComputation(String infrastructureId) throws SchedulerException {
        logger.infoV("Scheduling system metrics computation for infra %s with %s seconds frequency", new Object[]{infrastructureId, this.schedulerSystemMetricsBatchFrequencySeconds});
        HashMap<String, String> jobData = new HashMap<String, String>();
        jobData.put("infrastructureId", infrastructureId);
        this.addScheduledTaskSeconds(UnifiedMonitoringSnapshotComputationTask.ApiEndpointInfraSystemMetrics.class, this.getInfraSystemMetricsComputationJobKey(infrastructureId), this.schedulerSystemMetricsBatchFrequencySeconds, jobData);
    }

    private void scheduleExternalEndpointsScopeSnapshotComputation(String externalEndpointsScopeName, UnifiedMonitoringExternalEndpointsScope scope) throws SchedulerException {
        int frequency = this.getSchedulerEndpointsBatchFrequencyMinutes(scope);
        logger.infoV("Scheduling unmanaged external endpoints computation for external endpoint scope %s with %s minutes frequency", new Object[]{externalEndpointsScopeName, frequency});
        HashMap<String, String> jobData = new HashMap<String, String>();
        jobData.put("externalEndpointsScopeName", externalEndpointsScopeName);
        this.addScheduledTaskMinutes(UnifiedMonitoringSnapshotComputationTask.ExternalEndpointStatusesAndActivityMetrics.class, this.getExternalEndpointsScopeSnapshotComputationJobKey(externalEndpointsScopeName), frequency, jobData);
        this.externalEndpointsScopesToBeComputed.add(scope);
    }

    private void interruptAndResumeJobForDataCleanup(JobKey jobKey, Runnable cleanupFunction) {
        try {
            this.scheduler.interrupt(jobKey);
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to interrupt job %s", new Object[]{jobKey});
            return;
        }
        cleanupFunction.run();
        try {
            JobDetail job = this.scheduler.getJobDetail(jobKey);
            this.scheduler.triggerJob(job.getKey(), job.getJobDataMap());
        }
        catch (SchedulerException e) {
            logger.warnV((Throwable)e, "Failed to resume job %s", new Object[]{jobKey});
        }
    }

    private AbstractInfraBasicInfo getInfraBasicInfo(String infraId) throws UnauthorizedException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AbstractInfraBasicInfo abstractInfraBasicInfo = this.apiNodeInfrasService.getLightStatusUnsafe_Check(infraId, DSSAuthCtx.internalAdminAuth()).getInfraBasicInfo();
            return abstractInfraBasicInfo;
        }
    }
}

