/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.ComputedPluginContent;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.server.samples.SnippetOrigin;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTemplateService<T extends TemplateDesc> {
    @Autowired
    public IPluginsRegistryService pluginsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.templates");

    private T read(File directory, Class<T> clazz, Map<String, String> params) throws IOException {
        File meta = new File(directory, "meta.json");
        if (!meta.isFile()) {
            return null;
        }
        TemplateDesc td = (TemplateDesc)JSON.parseFile((File)meta, clazz);
        if (td != null) {
            td.id = directory.getName();
            this.finalizeTemplate(td, params);
        }
        return (T)td;
    }

    protected TemplateDescs<T> listTemplates(Class<T> clazz, Map<String, String> params, String ... chunks) throws IOException {
        TemplateDescs ret = new TemplateDescs();
        File userDir = ApplicationConfigurator.getUserResourceFile((String[])chunks);
        logger.warn((Object)("userDir" + userDir.getAbsolutePath()));
        for (File templateDir : DKUFileUtils.listSubfoldersContainingFile((File)userDir, (String)"meta.json")) {
            try {
                T td = this.read(templateDir, clazz, params);
                if (td == null) continue;
                ((TemplateDesc)td).origin = SnippetOrigin.CUSTOM;
                ret.templates.add(td);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read template from " + String.valueOf(templateDir)), (Throwable)e);
            }
        }
        File builtinDir = ApplicationConfigurator.getResourceFile((String[])chunks);
        logger.warn((Object)("builtinDir" + builtinDir.getAbsolutePath()));
        for (File templateDir : DKUFileUtils.listSubfoldersContainingFile((File)builtinDir, (String)"meta.json")) {
            try {
                T td = this.read(templateDir, clazz, params);
                if (td == null) continue;
                ((TemplateDesc)td).origin = SnippetOrigin.BUILTIN;
                ret.templates.add(td);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read template from " + String.valueOf(templateDir)), (Throwable)e);
            }
        }
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            File pluginResourceDirectory = this.pluginsService.getActualPluginFolder(ipd.desc.id);
            File templatesDir = DKUFileUtils.getWithin((File)pluginResourceDirectory, (String[])chunks);
            logger.trace(() -> "Checking for templates in plugin " + ipd.desc.id + ": " + String.valueOf(templatesDir));
            for (File templateDir : DKUFileUtils.listSubfoldersContainingFile((File)templatesDir, (String)"meta.json")) {
                try {
                    T td = this.read(templateDir, clazz, params);
                    if (td == null) continue;
                    ((TemplateDesc)td).origin = SnippetOrigin.PLUGIN;
                    ((TemplateDesc)td).pluginId = ipd.desc.id;
                    ret.templates.add(td);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read template from " + String.valueOf(templateDir)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    protected abstract void finalizeTemplate(T var1, Map<String, String> var2);

    protected File getTemplateDirectory(T desc, String ... chunks) throws Exception {
        Preconditions.checkArgument((((TemplateDesc)desc).origin != null ? 1 : 0) != 0, (Object)"Snippet origin is not specified");
        File templateDir = null;
        switch (((TemplateDesc)desc).origin) {
            case BUILTIN: {
                templateDir = ApplicationConfigurator.getResourceFile((String[])chunks);
                break;
            }
            case CUSTOM: {
                templateDir = ApplicationConfigurator.getUserResourceFile((String[])chunks);
                break;
            }
            case PLUGIN: {
                File pluginResourceDirectory = this.pluginsService.getActualPluginFolder(((TemplateDesc)desc).pluginId);
                templateDir = DKUFileUtils.getWithin((File)pluginResourceDirectory, (String[])chunks);
            }
        }
        if (templateDir == null) {
            throw ErrorContext.iae((String)("Unknown snippet origin: " + String.valueOf((Object)((TemplateDesc)desc).origin)));
        }
        return templateDir;
    }

    protected List<ComputedPluginContent.ContributionWithId> listTemplatesInPlugin(String pluginId, File pluginDir, String ... chunks) {
        ArrayList<ComputedPluginContent.ContributionWithId> ret = new ArrayList<ComputedPluginContent.ContributionWithId>();
        File templatesDir = DKUFileUtils.getWithin((File)pluginDir, (String[])chunks);
        String templatesDirPath = StringUtils.join((Object[])chunks, (String)"/");
        logger.trace(() -> "Checking for templates in plugin " + pluginId + ": " + String.valueOf(templatesDir));
        for (File templateDir : DKUFileUtils.listSubfoldersContainingFile((File)templatesDir, (String)"meta.json")) {
            try {
                File meta = new File(templateDir, "meta.json");
                if (!meta.isFile()) continue;
                String id = templateDir.getName();
                String folderName = templatesDirPath + "/" + id;
                DkuComponentMetadata customComponentMetadata = (DkuComponentMetadata)JSON.parseFile((File)meta, DkuComponentMetadata.class);
                ret.add(new ComputedPluginContent.ContributionWithId(id, customComponentMetadata, folderName));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read template from " + String.valueOf(templateDir)), (Throwable)e);
            }
        }
        return ret;
    }

    public static class TemplateDesc {
        public String id;
        public SnippetOrigin origin;
        public String pluginId;
        public String label;
        public String title;
        public String shortDesc;
    }

    public static class TemplateDescs<T extends TemplateDesc> {
        public List<T> templates = new ArrayList<T>();
    }
}

