/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.utils.JSON;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.ehcache.core.util.ByteBufferInputStream;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class DKUEhcacheSerializer<T>
implements Serializer<T> {
    final Class<T> clazz;

    public DKUEhcacheSerializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public ByteBuffer serialize(T o) throws SerializerException {
        if (WithCustomCacheSerializer.class.isAssignableFrom(this.clazz)) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ((WithCustomCacheSerializer)o).serializeToCache(new DataOutputStream(bos));
                return ByteBuffer.wrap(bos.toByteArray());
            }
            catch (IOException e) {
                throw new SerializerException((Throwable)e);
            }
        }
        return ByteBuffer.wrap(JSON.toBytes(o));
    }

    public T read(ByteBuffer byteBuffer) throws SerializerException {
        try {
            if (WithCustomCacheSerializer.class.isAssignableFrom(this.clazz)) {
                Constructor<T> ctor = this.clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                T instance = ctor.newInstance(new Object[0]);
                ((WithCustomCacheSerializer)instance).deserializeFromCache(new DataInputStream((InputStream)new ByteBufferInputStream(byteBuffer)));
                return instance;
            }
            return (T)JSON.parse((byte[])DKUIOUtils.toByteArray(byteBuffer, byteBuffer.limit()), this.clazz);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SerializerException((Throwable)e);
        }
    }

    public boolean equals(T o, ByteBuffer byteBuffer) throws ClassNotFoundException, SerializerException {
        return this.serialize(o).equals(byteBuffer);
    }

    public static interface WithCustomCacheSerializer {
        public void serializeToCache(DataOutputStream var1) throws IOException;

        public void deserializeFromCache(DataInputStream var1) throws IOException;
    }
}

