/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariableExpansionFilter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BuiltinVariableExpansionFilters {
    public static String jsonToString(JsonElement input) {
        if (input == null || input.isJsonNull()) {
            return "";
        }
        if (input.isJsonPrimitive()) {
            return input.getAsJsonPrimitive().getAsString();
        }
        return input.toString();
    }

    public static class FormatUnixTimestamp
    implements VariableExpansionFilter {
        private DateTimeFormatter format;

        @Override
        public void setParams(String params) {
            String pattern = StringUtils.defaultIfBlank((String)params.trim(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
            this.format = DateTimeFormat.forPattern((String)pattern);
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            if (input.isJsonPrimitive()) {
                long timestamp = input.getAsJsonPrimitive().isNumber() ? input.getAsJsonPrimitive().getAsLong() : Long.parseLong(input.getAsString());
                return new JsonPrimitive(this.format.print(timestamp));
            }
            throw new RuntimeException("filter only applies to numbers");
        }
    }

    public static class GetOrNull
    implements VariableExpansionFilter {
        private List<Object> path;

        @Override
        public void setParams(String params) {
            String pathStr = StringUtils.defaultIfBlank((String)params, (String)"");
            if (pathStr.isEmpty()) {
                throw new IllegalArgumentException("Parameter to getOrNull can't be empty, must be json-encoded array");
            }
            this.path = Lists.newArrayList();
            JsonArray a = (JsonArray)JSON.parse((String)pathStr, JsonArray.class);
            for (JsonElement e : a) {
                if (!e.isJsonPrimitive()) {
                    throw new IllegalArgumentException("Parameter to getOrNull can only use strings or integers in the path: " + String.valueOf(e));
                }
                JsonPrimitive p = e.getAsJsonPrimitive();
                if (p.isNumber()) {
                    this.path.add(p.getAsInt());
                    continue;
                }
                if (p.isString()) {
                    this.path.add(p.getAsString());
                    continue;
                }
                throw new IllegalArgumentException("Parameter to getOrNull can only use strings or integers in the path: " + String.valueOf(e));
            }
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            return JsonUtils.getOrNull(input, this.path.toArray());
        }
    }

    public static class ToJson
    implements VariableExpansionFilter {
        @Override
        public void setParams(String params) {
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            if (input.isJsonPrimitive()) {
                return input;
            }
            String inputStr = input.toString();
            return new JsonPrimitive(inputStr);
        }
    }

    public static class FromJson
    implements VariableExpansionFilter {
        @Override
        public void setParams(String params) {
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            String inputStr = input.toString();
            return (JsonElement)JSON.parse((String)inputStr, JsonElement.class);
        }
    }

    public static class Indent
    implements VariableExpansionFilter {
        private int indent;

        @Override
        public void setParams(String params) {
            this.indent = Integer.parseInt(StringUtils.defaultIfBlank((String)params, (String)"0"));
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull() || this.indent == 0) {
                return input;
            }
            String inputStr = input.toString();
            String[] lines = inputStr.split("\n");
            char[] spacesArray = new char[this.indent];
            Arrays.fill(spacesArray, ' ');
            String spaces = new String(spacesArray);
            String indented = Arrays.asList(lines).stream().map(l -> spaces + l).collect(Collectors.joining("\n"));
            return new JsonPrimitive(indented);
        }
    }

    public static class DefaultValue
    implements VariableExpansionFilter {
        private String defaultValue;

        @Override
        public void setParams(String params) {
            this.defaultValue = params;
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return new JsonPrimitive(this.defaultValue);
            }
            return input;
        }
    }

    public static class ToUpper
    implements VariableExpansionFilter {
        @Override
        public void setParams(String params) {
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            String inputStr = input.toString();
            return new JsonPrimitive(inputStr.toUpperCase(Locale.ENGLISH));
        }
    }

    public static class ToLower
    implements VariableExpansionFilter {
        @Override
        public void setParams(String params) {
        }

        @Override
        public JsonElement process(JsonElement input) {
            if (input == null || input.isJsonNull()) {
                return input;
            }
            String inputStr = input.toString();
            return new JsonPrimitive(inputStr.toLowerCase(Locale.ENGLISH));
        }
    }
}

