/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.LocalProcessExposition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;

public class WebAppBackendInfra {
    public ContainerExecSelection containerSelection = new ContainerExecSelection();
    public boolean overrideGlobalK8sExposition = false;
    public Exposition exposition = WebAppBackendInfra.makeDefaultExposition();
    public K8SAPIDeploymentInfra.K8SDeploymentScaling scaling = WebAppBackendInfra.makeDefaultScaling();
    public K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget podDisruptionBudget = WebAppBackendInfra.makeDefaultPDB();
    public K8SAPIDeploymentInfra.K8SYamlModifier deploymentModifier = new K8SAPIDeploymentInfra.K8SYamlModifier();

    public static Exposition makeDefaultExposition() {
        Exposition ret = new Exposition().withType(LocalProcessExposition.META.getType());
        try {
            ret.params = LocalProcessExposition.META.getParamsClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static K8SAPIDeploymentInfra.K8SDeploymentScaling makeDefaultScaling() {
        K8SAPIDeploymentInfra.K8SDeploymentScaling ret = new K8SAPIDeploymentInfra.K8SDeploymentScaling();
        ret.initialReplicas = 1;
        ret.hpa = false;
        return ret;
    }

    private static K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget makeDefaultPDB() {
        K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget ret = new K8SAPIDeploymentInfra.K8SDeploymentPodDisruptionBudget();
        ret.enable = false;
        ret.isMaxUnavailable = false;
        ret.minAvailable = "50%";
        return ret;
    }

    public Exposition getEffectiveExposition(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig config) throws IOException, DKUSecurityException {
        if (config == null) {
            return this.exposition;
        }
        ContainerSettings containerSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getContainerSettings();
        switch (config.type) {
            case KUBERNETES: {
                if (this.overrideGlobalK8sExposition) {
                    return this.exposition;
                }
                return (Exposition)JSON.parse((JsonElement)containerSettings.defaultWebappsK8SExposition, Exposition.class);
            }
            case DOCKER: {
                return (Exposition)JSON.parse((JsonElement)containerSettings.defaultWebappsDockerExposition, Exposition.class);
            }
        }
        throw new IllegalArgumentException("Unreachable");
    }

    public JsonObject getSensitiveSettings() {
        JsonObject ret = new JsonObject();
        ret.addProperty("overrideGlobalK8sExposition", Boolean.valueOf(this.overrideGlobalK8sExposition));
        ret.add("deploymentModifier", (JsonElement)this.deploymentModifier.getSensitiveSettings());
        ret.add("exposition", (JsonElement)this.exposition.getSensitiveSettings());
        return ret;
    }
}

