/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.plugins;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.plugins.CustomWebAppDesc;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomWebAppsService
extends AbstractElementService<CustomWebAppDesc, LoadedCustomWebApp> {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.webapps");

    @Override
    public String getFolderName() {
        return "webapps";
    }

    @Override
    public String getPrefix() {
        return "webapp";
    }

    @Override
    protected String getCodeExtension(LoadedCustomWebApp desc) {
        return "";
    }

    @Override
    public Class<CustomWebAppDesc> getDescClass() {
        return CustomWebAppDesc.class;
    }

    @Override
    public Class<LoadedCustomWebApp> getLoadedDescClass() {
        return LoadedCustomWebApp.class;
    }

    @Override
    protected void removeElement(LoadedCustomWebApp desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "webapp_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomWebApp load(String elementType, String pluginId, String elementId, File file) throws IOException {
        File ldFile;
        CustomWebAppDesc desc = (CustomWebAppDesc)JSON.parseFile((File)file, CustomWebAppDesc.class);
        desc.id = elementType;
        LoadedCustomWebApp loaded = new LoadedCustomWebApp(elementType, pluginId, elementId, desc);
        if (StringUtils.isBlank((String)loaded.desc.longDescription) && (ldFile = new File(file.getParent(), "long-description.md")).isFile()) {
            loaded.desc.longDescription = DKUFileUtils.readFileToStringUTF8((File)ldFile);
        }
        if (StringUtils.isBlank((String)loaded.desc.longDescription)) {
            loaded.desc.longDescription = loaded.desc.meta.description;
        }
        if (StringUtils.isBlank((String)desc.baseType)) {
            throw new IllegalArgumentException("baseType is required for plugin webapps");
        }
        CustomWebAppMeta stepMeta = new CustomWebAppMeta(loaded);
        WebAppRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomWebAppDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (!CustomWebAppMeta.supportedBaseTypes.contains(desc.baseType)) {
                    this.withFatal("Plugin webapp require a \"baseType\" field set to STANDARD, BOKEH, DASH, SHINY or STREAMLIT.");
                }
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomWebAppsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (desc.roles != null) {
                    for (CustomWebAppDesc.WebAppRole r : desc.roles) {
                        if (r.type != null) continue;
                        this.withWarning("Unknown webapp role");
                    }
                }
                return this.messages;
            }
        }.validate();
    }

    public String getPythonLibFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        LoadedCustomWebApp loadedDesc = (LoadedCustomWebApp)this.loadedDescs.get(elementType);
        File libDir = this.pluginsService.getPluginPythonlibFolder(loadedDesc.getOwnerPluginId());
        return libDir.getAbsolutePath();
    }
}

