/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny;

import com.dataiku.dip.webapps.CustomWebAppHandler;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.shiny.AbstractShinyWebAppHandler;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;

public class CustomShinyWebAppHandler
extends AbstractShinyWebAppHandler
implements CustomWebAppHandler {
    private File directory;

    public CustomShinyWebAppHandler(WebApp webapp, File directory) {
        super(webapp);
        this.directory = directory;
    }

    @Override
    public void writeCodeFiles() throws IOException {
    }

    @Override
    public void deleteCodeFiles() throws IOException {
    }

    @Override
    public void readCodeFiles() {
        try {
            if (!this.getUiFile().exists()) {
                throw new IllegalStateException("The Shiny plugin webapp has no UI file");
            }
            if (!this.getServerFile().exists()) {
                throw new IllegalStateException("The Shiny plugin webapp has no UI file");
            }
            this.params.ui = FileUtils.readFileToString((File)this.getUiFile());
            this.params.server = FileUtils.readFileToString((File)this.getServerFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void expandVariablesForConversion() {
        this.readCodeFiles();
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Map.Entry e : this.webapp.config.entrySet()) {
            vars.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
        }
        this.params.ui = StrSubstitutor.replace((Object)this.params.ui, vars);
        this.params.server = StrSubstitutor.replace((Object)this.params.server, vars);
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }

    private File getServerFile() {
        return new File(this.directory, "server.R");
    }

    private File getUiFile() {
        return new File(this.directory, "ui.R");
    }
}

