/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.api;

import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.lambda.model.api.SinglePredictionQuery;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;

public class SnowparkQuery {
    public List<JsonArray> data;

    public List<Pair<Integer, JsonObject>> toItems() {
        return this.data.stream().map(SnowparkQuery::extractItems).collect(Collectors.toList());
    }

    public List<Pair<Integer, SinglePredictionQuery>> toSinglePredictionQueries() {
        return this.data.stream().map(SnowparkQuery::extractItems).map(SnowparkQuery::convertToSinglePredictionQuery).collect(Collectors.toList());
    }

    private static Pair<Integer, JsonObject> extractItems(JsonArray arr) {
        if (arr.size() != 2) {
            throw new IllegalArgumentException("Snowpark row should have a length of 2 in the form [(int) index, (String) features_json]");
        }
        int index = arr.get(0).getAsInt();
        String featuresStr = arr.get(1).getAsString();
        JsonObject features = (JsonObject)JSON.parse((String)featuresStr, JsonObject.class);
        return new Pair((Object)index, (Object)features);
    }

    private static Pair<Integer, SinglePredictionQuery> convertToSinglePredictionQuery(Pair<Integer, JsonObject> pair) {
        SinglePredictionQuery predictionQuery = (SinglePredictionQuery)JSON.parse((JsonElement)((JsonElement)pair.second), SinglePredictionQuery.class);
        return new Pair((Object)((Integer)pair.first), (Object)predictionQuery);
    }
}

