/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AsBool
implements Function {
    private static Map<String, Boolean> data;

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least an argument");
        }
        if (args[0] == null) {
            return null;
        }
        if (args[0] instanceof Boolean) {
            return args[0];
        }
        if (args[0] instanceof Number) {
            Number numBool = (Number)args[0];
            return numBool.doubleValue() != 0.0;
        }
        if (args[0] instanceof String) {
            String strBool = ((String)args[0]).toLowerCase();
            if (strBool.isEmpty()) {
                return null;
            }
            if (data.containsKey(strBool)) {
                return data.get(strBool);
            }
            return new EvalError("Value '" + strBool + "' cannot be converted to boolean");
        }
        return new EvalError("Not a String - cannot parse to boolean");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.AsBool.DOCUMENTATION", "Returns <code>o</code> converted to a boolean.").withParams("o").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.BOOLEAN", "Boolean functions").withExample(Example.with("0").returns("false")).withExample(Example.with("\"yes\"").returns("true"));
    }

    static {
        Map<String, Boolean> knownForms = data = new HashMap<String, Boolean>();
        knownForms.put("true", true);
        knownForms.put("false", false);
        knownForms.put("yes", true);
        knownForms.put("no", false);
        knownForms.put("1", true);
        knownForms.put("0", false);
        knownForms.put("y", true);
        knownForms.put("n", false);
        knownForms.put("t", true);
        knownForms.put("f", false);
        knownForms.put("o", true);
    }
}

