/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class AsDateOnly
implements Function {
    DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    private LocalDate parseDate(String date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC);
            return formatter.parseLocalDate(date);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        String strDate;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least an argument");
        }
        if (args[0] instanceof LocalDate) {
            return args[0];
        }
        if (args[0] instanceof LocalDateTime) {
            return ((LocalDateTime)args[0]).toLocalDate();
        }
        if (args[0] instanceof DateTime) {
            return ((DateTime)args[0]).toLocalDate();
        }
        if (args[0] instanceof Date) {
            return new LocalDate(((Date)args[0]).getTime(), DateTimeZone.UTC);
        }
        if (args[0] instanceof Calendar) {
            return new LocalDate((Object)((Calendar)args[0]).getTime(), DateTimeZone.UTC);
        }
        if (args[0] instanceof Long) {
            strDate = ((Long)args[0]).toString();
        } else if (args[0] instanceof String) {
            strDate = (String)args[0];
            if (strDate.isEmpty()) {
                return new EvalError("Empty string (in " + GrelControlFunctionRegistry.getInstance().getFunctionName(this) + ")");
            }
        } else {
            return new EvalError("Not a String - cannot parse to date only");
        }
        if (args.length >= 2) {
            for (int i = 1; i < args.length; ++i) {
                LocalDate date;
                if (!(args[i] instanceof String) || (date = this.parseDate(strDate, (String)args[i])) == null) continue;
                return date;
            }
        } else {
            LocalDate date;
            try {
                date = this.formulaUtils.asDateOnly(strDate, bindings);
            }
            catch (Exception e) {
                try {
                    date = this.formulaUtils.asDatetimeNoTz(strDate, bindings).toLocalDate();
                }
                catch (Exception e2) {
                    try {
                        date = this.formulaUtils.asDate(strDate, bindings).toLocalDate();
                    }
                    catch (Exception e3) {
                        throw e;
                    }
                }
            }
            if (date != null) {
                return date;
            }
        }
        return new EvalError("Unable to parse as date only: " + String.valueOf(args[0]));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.AsDateOnly.DOCUMENTATION", "Returns <code>o</code> converted to <code>date only</code>. If you don't give a format, ISO-8601 is used. You can give an ordered list of possible formats using this syntax: <a href=\"https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html\" target=\"dss_formula\">SimpleDateFormat</a>. The <code>format</code> arguments are ignored when using the SQL engine.").withParams("o, [format1 ...]").withReturns("date only").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("\"2020-04\"", "\"yyyy-MM\"").returns("2020-04-01"));
    }
}

