/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.dataiku.ArrayIndexOf;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class ArrayContains
implements Function {
    private static ArrayIndexOf arrayIndexOf = new ArrayIndexOf();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 2 || args[0] == null || args[1] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two arguments");
        }
        Object v = arrayIndexOf.call(bindings, args);
        if (ExpressionUtils.isError(v)) {
            return v;
        }
        return (Integer)v > -1;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ArrayContains.DOCUMENTATION", "Returns whether the array <code>a</code> contains <code>item</code>.").withParams("array a", "item").withReturns("boolean").withExample(Example.with("[1,2,3]", "5").returns("false")).withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions");
    }
}

