/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Char
implements Function {
    private String arityError() {
        return GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires a number as argument";
    }

    private int convertToInteger(Number rhs) {
        return (int)Math.round(rhs.doubleValue());
    }

    @Override
    public String checkArguments(Evaluable[] args) {
        return args.length == 1 ? null : this.arityError();
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        return args.length == 1 && args[0] != null && args[0] instanceof Number ? Character.toString(this.convertToInteger((Number)args[0])) : new EvalError(this.arityError());
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Char.DOCUMENTATION", "Returns the character that represents the specified unicode.").withParams("number x").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("65").returns("\"A\""));
    }
}

