/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.json.JSONObject;

public class ObjectDel
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 1) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects at least one argument: ");
        }
        JSONObject prev = DKUFormulaUtils.asJSONObject(args[0]);
        for (int i = 0; i < args.length; ++i) {
            Object k = args[i];
            if (k == null) {
                return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " got a null key");
            }
            prev.remove(k.toString());
        }
        return prev;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ObjectDel.DOCUMENTATION", "Removes one or several keys from an object and returns it. The keys must not be null.").withParams("key, [key...]").withReturns("object").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions").withExample(Example.with("{\"name\":\"Smith\",\"age\":42}", "\"age\"").returns("{\"name\":\"Smith\"}"));
    }
}

