/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Chomp
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object o1 = args[0];
            Object o2 = args[1];
            if (o1 instanceof String && o2 instanceof String) {
                return StringUtils.chomp((String)((String)o1), (String)((String)o2));
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Chomp.DOCUMENTATION", "Removes <code>tail</code> from the end of <code>s</code> if it's there, otherwise leave it alone.").withParams("string s, string tail").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"foobar\"", "\"bar\"").returns("\"foo\""));
    }
}

