/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.google.refine.grel.Example;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Documentation {
    public String descriptionTranslationId;
    public String description;
    public List<Example> examples = new ArrayList<Example>();
    public String params;
    public String returnsTranslationId;
    public String returns;
    public String categoryTranslationId;
    public String category;
    public boolean hidden;
    public boolean deprecated;
    public String deprecationNoticeTranslationId;
    public String deprecationNotice;

    public Documentation(String description) {
        this.description = description;
    }

    public Documentation(String translationId, String description) {
        this.descriptionTranslationId = translationId;
        this.description = description;
    }

    public Documentation withDescription(String str) {
        this.description = str;
        return this;
    }

    public Documentation withDescription(String translationId, String str) {
        this.descriptionTranslationId = translationId;
        this.description = str;
        return this;
    }

    public Documentation withExample(Example example) {
        this.examples.add(example);
        return this;
    }

    public Documentation withParams(String ... params) {
        this.params = Joiner.on((String)", ").join((Object[])params);
        return this;
    }

    public Documentation withReturns(String returns) {
        this.returns = returns;
        return this;
    }

    public Documentation withReturns(String translationId, String returns) {
        this.returnsTranslationId = translationId;
        this.returns = returns;
        return this;
    }

    public Documentation withCategory(String category) {
        this.category = category;
        return this;
    }

    public Documentation withCategory(String translationId, String category) {
        this.categoryTranslationId = translationId;
        this.category = category;
        return this;
    }

    public Documentation withHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Documentation withDeprecated() {
        return this.withDeprecated(null, null);
    }

    public Documentation withDeprecated(@Nullable String translationId, @Nullable String message) {
        this.deprecated = true;
        this.deprecationNoticeTranslationId = translationId;
        this.deprecationNotice = message;
        return this;
    }
}

