/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ForEachIndex
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 4) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 4 arguments";
        }
        if (!(args[1] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects second argument to be the index's variable name";
        }
        if (!(args[2] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects third argument to be the element's variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object o = args[0].evaluate(bindings);
        if (ExpressionUtils.isError(o)) {
            return o;
        }
        if (o == null) {
            return null;
        }
        String indexName = ((VariableExpr)args[1]).getName();
        String elementName = ((VariableExpr)args[2]).getName();
        Object oldIndexValue = bindings.get(indexName);
        Object oldElementValue = bindings.get(elementName);
        try {
            List<?> input = DKUFormulaUtils.asList(o);
            ArrayList<Object> results = new ArrayList<Object>(input.size());
            for (int i = 0; i < input.size(); ++i) {
                Object v = input.get(i);
                bindings.put(indexName, (Object)i);
                bindings.put(elementName, v);
                Object r = args[3].evaluate(bindings);
                results.add(r);
            }
            Object[] objectArray = results.toArray();
            return objectArray;
        }
        finally {
            if (oldIndexValue != null) {
                bindings.put(indexName, oldIndexValue);
            } else {
                bindings.remove(indexName);
            }
            if (oldElementValue != null) {
                bindings.put(elementName, oldElementValue);
            } else {
                bindings.remove(elementName);
            }
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ForEachIndex.DOCUMENTATION", "Evaluates expression <code>a</code> to an array. Then for each array element, binds its value to variable name <code>v</code> and its index to variable name <code>i</code>, evaluates expression <code>e</code>, and pushes the result onto the result array.").withParams("expression a, variable i, variable v, expression e").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("[1,2,4,9]", "i", "item", "i<2 || item%2==1").returns("[true,true,false,true]"));
    }
}

