/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.dataiku.dip.i18n.LocalizedString;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.controls.IsTest;

public class IsBlank
extends IsTest {
    @Override
    protected LocalizedString getDescription() {
        return new LocalizedString("GREL.FUNCTION.IsBlank.DOCUMENTATION", "Returns whether <code>o</code> is null or an empty string. It returns true when value is null or empty (\"\").<br/>It does not consider a string made of blank spaces as blank; it considers an expression with an error as blank.");
    }

    @Override
    protected boolean test(Object o) {
        return !ExpressionUtils.isNonBlankData(o);
    }

    @Override
    public Documentation getDocumentation() {
        return super.getDocumentation().withExample(Example.with("\"\"").returns("true")).withExample(Example.with("\" \"").returns("false")).withExample(Example.with("abs(\"a\")").returns("true"));
    }
}

