/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

import com.tlarsendataguy.yxdb.BufferedRecordReader;
import com.tlarsendataguy.yxdb.MetaInfoField;
import com.tlarsendataguy.yxdb.YxdbField;
import com.tlarsendataguy.yxdb.YxdbRecord;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class YxdbReader {
    public long numRecords;
    private int metaInfoSize;
    public String metaInfoStr;
    private final List<MetaInfoField> fields;
    private final BufferedInputStream stream;
    private final String path;
    private YxdbRecord record;
    private BufferedRecordReader recordReader;

    public YxdbReader(String path) throws IOException, IllegalArgumentException {
        this.path = path;
        File file = new File(this.path);
        this.stream = new BufferedInputStream(new FileInputStream(file));
        this.fields = new ArrayList<MetaInfoField>();
        this.loadHeaderAndMetaInfo();
    }

    public YxdbReader(BufferedInputStream stream) throws IOException, IllegalArgumentException {
        this.path = "";
        this.stream = stream;
        this.fields = new ArrayList<MetaInfoField>();
        this.loadHeaderAndMetaInfo();
    }

    public List<YxdbField> listFields() {
        return this.record.fields;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean next() throws IOException {
        return this.recordReader.nextRecord();
    }

    public Byte readByte(int index) throws IllegalArgumentException {
        return this.record.extractByteFrom(index, this.recordReader.recordBuffer);
    }

    public Byte readByte(String name) throws IllegalArgumentException {
        return this.record.extractByteFrom(name, this.recordReader.recordBuffer);
    }

    public Boolean readBoolean(int index) throws IllegalArgumentException {
        return this.record.extractBooleanFrom(index, this.recordReader.recordBuffer);
    }

    public Boolean readBoolean(String name) throws IllegalArgumentException {
        return this.record.extractBooleanFrom(name, this.recordReader.recordBuffer);
    }

    public Long readLong(int index) throws IllegalArgumentException {
        return this.record.extractLongFrom(index, this.recordReader.recordBuffer);
    }

    public Long readLong(String name) throws IllegalArgumentException {
        return this.record.extractLongFrom(name, this.recordReader.recordBuffer);
    }

    public Double readDouble(int index) throws IllegalArgumentException {
        return this.record.extractDoubleFrom(index, this.recordReader.recordBuffer);
    }

    public Double readDouble(String name) throws IllegalArgumentException {
        return this.record.extractDoubleFrom(name, this.recordReader.recordBuffer);
    }

    public String readString(int index) throws IllegalArgumentException {
        return this.record.extractStringFrom(index, this.recordReader.recordBuffer);
    }

    public String readString(String name) throws IllegalArgumentException {
        return this.record.extractStringFrom(name, this.recordReader.recordBuffer);
    }

    public LocalDate readDate(int index) throws IllegalArgumentException {
        return this.record.extractDateFrom(index, this.recordReader.recordBuffer);
    }

    public LocalDate readDate(String name) throws IllegalArgumentException {
        return this.record.extractDateFrom(name, this.recordReader.recordBuffer);
    }

    public LocalDateTime readDateTime(int index) throws IllegalArgumentException {
        return this.record.extractDateTimeFrom(index, this.recordReader.recordBuffer);
    }

    public LocalDateTime readDateTime(String name) throws IllegalArgumentException {
        return this.record.extractDateTimeFrom(name, this.recordReader.recordBuffer);
    }

    public byte[] readBlob(int index) throws IllegalArgumentException {
        return this.record.extractBlobFrom(index, this.recordReader.recordBuffer);
    }

    public byte[] readBlob(String name) throws IllegalArgumentException {
        return this.record.extractBlobFrom(name, this.recordReader.recordBuffer);
    }

    private void loadHeaderAndMetaInfo() throws IOException, IllegalArgumentException {
        ByteBuffer header = this.getHeader();
        String fileType = new String(header.array(), 0, 21, StandardCharsets.ISO_8859_1);
        if (!"Alteryx Database File".equals(fileType)) {
            String errorMessage = "Alteryx e2 Database f".equals(fileType) ? "Unsupported YXDB file format (Alteryx e2 Database file). This file has been generated with AMP Engine which cannot be read by DSS. To generate a supported YXDB file uncheck 'Use AMP engine' in Alteryx." : "File is not a valid YXDB file: Invalid signature";
            this.closeStreamAndThrow(errorMessage);
        }
        this.numRecords = header.getLong(104);
        this.metaInfoSize = header.getInt(80);
        this.loadMetaInfo();
        this.record = YxdbRecord.newFromFieldList(this.fields);
        this.recordReader = new BufferedRecordReader(this.stream, this.record.fixedSize, this.record.hasVar, this.numRecords);
    }

    private void loadMetaInfo() throws IOException, IllegalArgumentException {
        long skipped;
        byte[] metaInfoBytes = this.stream.readNBytes(this.metaInfoSize * 2 - 2);
        if (metaInfoBytes.length < this.metaInfoSize * 2 - 2) {
            this.closeStreamAndThrow();
        }
        if ((skipped = this.stream.skip(2L)) != 2L) {
            this.closeStreamAndThrow();
        }
        this.metaInfoStr = new String(metaInfoBytes, StandardCharsets.UTF_16LE);
        this.getFields();
    }

    private ByteBuffer getHeader() throws IOException, IllegalArgumentException {
        byte[] headerBytes = new byte[512];
        int written = this.stream.readNBytes(headerBytes, 0, 512);
        if (written < 512) {
            this.closeStreamAndThrow();
        }
        return ByteBuffer.wrap(headerBytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void getFields() throws IllegalArgumentException {
        NodeList nodes = this.getRecordInfoNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node field = nodes.item(i);
            if (field.getNodeType() != 1) continue;
            this.parseField(field);
        }
    }

    private NodeList getRecordInfoNodes() {
        Document doc;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(this.metaInfoStr)));
            doc.getDocumentElement().normalize();
        }
        catch (Exception ex) {
            this.closeStreamAndThrow();
            throw new IllegalArgumentException();
        }
        Node info = doc.getElementsByTagName("RecordInfo").item(0);
        return info.getChildNodes();
    }

    private void parseField(Node field) {
        NamedNodeMap attributes = field.getAttributes();
        Node name = attributes.getNamedItem("name");
        Node size = attributes.getNamedItem("size");
        Node type = attributes.getNamedItem("type");
        Node scale = attributes.getNamedItem("scale");
        if (name == null || type == null) {
            this.closeStreamAndThrow();
            return;
        }
        String nameStr = name.getNodeValue();
        switch (type.getNodeValue()) {
            case "Byte": {
                this.fields.add(new MetaInfoField(nameStr, "Byte", 1, 0));
                break;
            }
            case "Bool": {
                this.fields.add(new MetaInfoField(nameStr, "Bool", 1, 0));
                break;
            }
            case "Int16": {
                this.fields.add(new MetaInfoField(nameStr, "Int16", 2, 0));
                break;
            }
            case "Int32": {
                this.fields.add(new MetaInfoField(nameStr, "Int32", 4, 0));
                break;
            }
            case "Int64": {
                this.fields.add(new MetaInfoField(nameStr, "Int64", 8, 0));
                break;
            }
            case "FixedDecimal": {
                if (scale == null || size == null) {
                    this.closeStreamAndThrow();
                    return;
                }
                this.fields.add(new MetaInfoField(nameStr, "FixedDecimal", Integer.parseInt(size.getNodeValue()), Integer.parseInt(scale.getNodeValue())));
                break;
            }
            case "Float": {
                this.fields.add(new MetaInfoField(nameStr, "Float", 4, 0));
                break;
            }
            case "Double": {
                this.fields.add(new MetaInfoField(nameStr, "Double", 8, 0));
                break;
            }
            case "String": {
                if (size == null) {
                    this.closeStreamAndThrow();
                    return;
                }
                this.fields.add(new MetaInfoField(nameStr, "String", Integer.parseInt(size.getNodeValue()), 0));
                break;
            }
            case "WString": {
                if (size == null) {
                    this.closeStreamAndThrow();
                    return;
                }
                this.fields.add(new MetaInfoField(nameStr, "WString", Integer.parseInt(size.getNodeValue()), 0));
                break;
            }
            case "V_String": 
            case "V_WString": 
            case "Blob": 
            case "SpatialObj": {
                this.fields.add(new MetaInfoField(nameStr, type.getNodeValue(), 4, 0));
                break;
            }
            case "Date": {
                this.fields.add(new MetaInfoField(nameStr, "Date", 10, 0));
                break;
            }
            case "DateTime": {
                this.fields.add(new MetaInfoField(nameStr, "DateTime", 19, 0));
                break;
            }
            default: {
                this.closeStreamAndThrow();
            }
        }
    }

    private void closeStreamAndThrow(String errorMessage) throws IllegalArgumentException {
        try {
            this.stream.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(errorMessage, ex);
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private void closeStreamAndThrow() throws IllegalArgumentException {
        this.closeStreamAndThrow("File is not a valid YXDB file");
    }
}

