/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static Map<String, String> parseJSONKeyValueMap(String string) {
        if (string == null || string.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return MAPPER.readValue(string, new TypeReference<Map<String, String>>(){});
        }
        catch (Exception exception) {
            throw new KernelException(String.format("Failed to parse JSON string: %s", string), exception);
        }
    }
}

