/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonToken;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.type.WritableTypeId;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.JsonMappingException;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.SerializerProvider;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import com.dataiku.dss.shadelibtd.org.json.JSONArray;
import com.dataiku.dss.shadelibtd.org.json.JSONObject;
import java.io.IOException;
import java.lang.reflect.Type;

public class JSONArraySerializer
extends JSONBaseSerializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArraySerializer instance = new JSONArraySerializer();

    public JSONArraySerializer() {
        super(JSONArray.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, JSONArray value) {
        return value == null || value.length() == 0;
    }

    @Override
    public void serialize(JSONArray value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeStartArray();
        this.serializeContents(value, g2, provider);
        g2.writeEndArray();
    }

    @Override
    public void serializeWithType(JSONArray value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JSONArray value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            Object ob = value.opt(i);
            if (ob == null || ob == JSONObject.NULL) {
                g2.writeNull();
                continue;
            }
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, g2, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                this.serialize((JSONArray)ob, g2, provider);
                continue;
            }
            if (cls == String.class) {
                g2.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                g2.writeNumber((Integer)ob);
                continue;
            }
            if (cls == Long.class) {
                g2.writeNumber((Long)ob);
                continue;
            }
            if (cls == Boolean.class) {
                g2.writeBoolean((Boolean)ob);
                continue;
            }
            if (cls == Double.class) {
                g2.writeNumber((Double)ob);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, g2, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                this.serialize((JSONArray)ob, g2, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, g2);
        }
    }
}

