/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Method;

public class BooleanUnmarshaller
implements ArgumentUnmarshaller {
    private static final BooleanUnmarshaller INSTANCE = new BooleanUnmarshaller();

    public static BooleanUnmarshaller instance() {
        return INSTANCE;
    }

    private BooleanUnmarshaller() {
    }

    @Override
    public void typeCheck(AttributeValue value, Method setter) {
        if (value.getN() == null && value.getBOOL() == null) {
            throw new DynamoDBMappingException("Expected either N or BOOL in value " + value + " when invoking " + setter);
        }
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        if (value.getBOOL() != null) {
            return value.getBOOL();
        }
        if ("1".equals(value.getN())) {
            return Boolean.TRUE;
        }
        if ("0".equals(value.getN())) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Expected '1', '0', or BOOL value for boolean value, was " + value);
    }
}

