/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EnaSrdSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EnaSrdUdpSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class AttachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<AttachNetworkInterfaceRequest>, AttachNetworkInterfaceRequest> {
    @Override
    public Request<AttachNetworkInterfaceRequest> marshall(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        EnaSrdSpecification enaSrdSpecification;
        if (attachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachNetworkInterfaceRequest> request = new DefaultRequest<AttachNetworkInterfaceRequest>(attachNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "AttachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachNetworkInterfaceRequest.getDeviceIndex() != null) {
            request.addParameter("DeviceIndex", StringUtils.fromInteger(attachNetworkInterfaceRequest.getDeviceIndex()));
        }
        if (attachNetworkInterfaceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(attachNetworkInterfaceRequest.getInstanceId()));
        }
        if (attachNetworkInterfaceRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(attachNetworkInterfaceRequest.getNetworkInterfaceId()));
        }
        if (attachNetworkInterfaceRequest.getNetworkCardIndex() != null) {
            request.addParameter("NetworkCardIndex", StringUtils.fromInteger(attachNetworkInterfaceRequest.getNetworkCardIndex()));
        }
        if ((enaSrdSpecification = attachNetworkInterfaceRequest.getEnaSrdSpecification()) != null) {
            EnaSrdUdpSpecification enaSrdUdpSpecification;
            if (enaSrdSpecification.getEnaSrdEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdEnabled", StringUtils.fromBoolean(enaSrdSpecification.getEnaSrdEnabled()));
            }
            if ((enaSrdUdpSpecification = enaSrdSpecification.getEnaSrdUdpSpecification()) != null && enaSrdUdpSpecification.getEnaSrdUdpEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdUdpSpecification.EnaSrdUdpEnabled", StringUtils.fromBoolean(enaSrdUdpSpecification.getEnaSrdUdpEnabled()));
            }
        }
        return request;
    }
}

