/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateInstanceConnectEndpointRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateInstanceConnectEndpointRequestMarshaller
implements Marshaller<Request<CreateInstanceConnectEndpointRequest>, CreateInstanceConnectEndpointRequest> {
    @Override
    public Request<CreateInstanceConnectEndpointRequest> marshall(CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest) {
        SdkInternalList createInstanceConnectEndpointRequestSecurityGroupIdsList;
        if (createInstanceConnectEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstanceConnectEndpointRequest> request = new DefaultRequest<CreateInstanceConnectEndpointRequest>(createInstanceConnectEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceConnectEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceConnectEndpointRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(createInstanceConnectEndpointRequest.getSubnetId()));
        }
        if (!(createInstanceConnectEndpointRequestSecurityGroupIdsList = (SdkInternalList)createInstanceConnectEndpointRequest.getSecurityGroupIds()).isEmpty() || !createInstanceConnectEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createInstanceConnectEndpointRequestSecurityGroupIdsListValue : createInstanceConnectEndpointRequestSecurityGroupIdsList) {
                if (createInstanceConnectEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(createInstanceConnectEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createInstanceConnectEndpointRequest.getPreserveClientIp() != null) {
            request.addParameter("PreserveClientIp", StringUtils.fromBoolean(createInstanceConnectEndpointRequest.getPreserveClientIp()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createInstanceConnectEndpointRequest.getClientToken()));
        SdkInternalList createInstanceConnectEndpointRequestTagSpecificationsList = (SdkInternalList)createInstanceConnectEndpointRequest.getTagSpecifications();
        if (!createInstanceConnectEndpointRequestTagSpecificationsList.isEmpty() || !createInstanceConnectEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createInstanceConnectEndpointRequestTagSpecificationsListValue : createInstanceConnectEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createInstanceConnectEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createInstanceConnectEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createInstanceConnectEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

