/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.GpuDeviceInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.GpuInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform.GpuDeviceInfoStaxUnmarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class GpuInfoStaxUnmarshaller
implements Unmarshaller<GpuInfo, StaxUnmarshallerContext> {
    private static GpuInfoStaxUnmarshaller instance;

    @Override
    public GpuInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        GpuInfo gpuInfo = new GpuInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return gpuInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("gpus", targetDepth)) {
                    gpuInfo.withGpus(new ArrayList<GpuDeviceInfo>());
                    continue;
                }
                if (context.testExpression("gpus/item", targetDepth)) {
                    gpuInfo.withGpus(GpuDeviceInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalGpuMemoryInMiB", targetDepth)) continue;
                gpuInfo.setTotalGpuMemoryInMiB(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return gpuInfo;
    }

    public static GpuInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GpuInfoStaxUnmarshaller();
        }
        return instance;
    }
}

