/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.DatabaseIdentifier;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.FederatedDatabase;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.PrincipalPermissions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.DatabaseInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String locationUri;
    private Map<String, String> parameters;
    private List<PrincipalPermissions> createTableDefaultPermissions;
    private DatabaseIdentifier targetDatabase;
    private FederatedDatabase federatedDatabase;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseInput withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DatabaseInput withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public DatabaseInput withLocationUri(String locationUri) {
        this.setLocationUri(locationUri);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public DatabaseInput withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public DatabaseInput addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public DatabaseInput clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public List<PrincipalPermissions> getCreateTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }

    public void setCreateTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
        if (createTableDefaultPermissions == null) {
            this.createTableDefaultPermissions = null;
            return;
        }
        this.createTableDefaultPermissions = new ArrayList<PrincipalPermissions>(createTableDefaultPermissions);
    }

    public DatabaseInput withCreateTableDefaultPermissions(PrincipalPermissions ... createTableDefaultPermissions) {
        if (this.createTableDefaultPermissions == null) {
            this.setCreateTableDefaultPermissions(new ArrayList<PrincipalPermissions>(createTableDefaultPermissions.length));
        }
        for (PrincipalPermissions ele : createTableDefaultPermissions) {
            this.createTableDefaultPermissions.add(ele);
        }
        return this;
    }

    public DatabaseInput withCreateTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
        this.setCreateTableDefaultPermissions(createTableDefaultPermissions);
        return this;
    }

    public void setTargetDatabase(DatabaseIdentifier targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    public DatabaseIdentifier getTargetDatabase() {
        return this.targetDatabase;
    }

    public DatabaseInput withTargetDatabase(DatabaseIdentifier targetDatabase) {
        this.setTargetDatabase(targetDatabase);
        return this;
    }

    public void setFederatedDatabase(FederatedDatabase federatedDatabase) {
        this.federatedDatabase = federatedDatabase;
    }

    public FederatedDatabase getFederatedDatabase() {
        return this.federatedDatabase;
    }

    public DatabaseInput withFederatedDatabase(FederatedDatabase federatedDatabase) {
        this.setFederatedDatabase(federatedDatabase);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLocationUri() != null) {
            sb.append("LocationUri: ").append(this.getLocationUri()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getCreateTableDefaultPermissions() != null) {
            sb.append("CreateTableDefaultPermissions: ").append(this.getCreateTableDefaultPermissions()).append(",");
        }
        if (this.getTargetDatabase() != null) {
            sb.append("TargetDatabase: ").append(this.getTargetDatabase()).append(",");
        }
        if (this.getFederatedDatabase() != null) {
            sb.append("FederatedDatabase: ").append(this.getFederatedDatabase());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInput)) {
            return false;
        }
        DatabaseInput other = (DatabaseInput)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLocationUri() == null ^ this.getLocationUri() == null) {
            return false;
        }
        if (other.getLocationUri() != null && !other.getLocationUri().equals(this.getLocationUri())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getCreateTableDefaultPermissions() == null ^ this.getCreateTableDefaultPermissions() == null) {
            return false;
        }
        if (other.getCreateTableDefaultPermissions() != null && !other.getCreateTableDefaultPermissions().equals(this.getCreateTableDefaultPermissions())) {
            return false;
        }
        if (other.getTargetDatabase() == null ^ this.getTargetDatabase() == null) {
            return false;
        }
        if (other.getTargetDatabase() != null && !other.getTargetDatabase().equals(this.getTargetDatabase())) {
            return false;
        }
        if (other.getFederatedDatabase() == null ^ this.getFederatedDatabase() == null) {
            return false;
        }
        return other.getFederatedDatabase() == null || other.getFederatedDatabase().equals(this.getFederatedDatabase());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLocationUri() == null ? 0 : this.getLocationUri().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTableDefaultPermissions() == null ? 0 : this.getCreateTableDefaultPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDatabase() == null ? 0 : this.getTargetDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getFederatedDatabase() == null ? 0 : this.getFederatedDatabase().hashCode());
        return hashCode;
    }

    public DatabaseInput clone() {
        try {
            return (DatabaseInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatabaseInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

