/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    @Override
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserRequest> request = new DefaultRequest<CreateUserRequest>(createUserRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString(createUserRequest.getPath()));
        }
        if (createUserRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createUserRequest.getUserName()));
        }
        if (createUserRequest.getPermissionsBoundary() != null) {
            request.addParameter("PermissionsBoundary", StringUtils.fromString(createUserRequest.getPermissionsBoundary()));
        }
        if (!createUserRequest.getTags().isEmpty() || !((SdkInternalList)createUserRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createUserRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

