/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Buffers;
import net.snowflake.client.jdbc.internal.google.cloud.storage.RewindableContent;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnbufferedWritableByteChannelSession;

final class RewindableContentInputStream
extends InputStream {
    private final RewindableContent content;

    RewindableContentInputStream(RewindableContent content) {
        this.content = content;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int read = this.read(tmp);
        if (read == -1) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        final ByteBuffer dst = ByteBuffer.wrap(b, off, len);
        int remaining = dst.remaining();
        if (remaining == 0) {
            return 0;
        }
        long written = this.content.writeTo(new AnonWritableByteChannel(){

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) {
                long total = 0L;
                for (int i = offset; i < length; ++i) {
                    ByteBuffer src = srcs[i];
                    long written = Buffers.copy(src, dst);
                    total += written;
                }
                return total;
            }
        });
        if (written == 0L) {
            return -1;
        }
        return Math.toIntExact(written);
    }

    private static abstract class AnonWritableByteChannel
    implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
        private AnonWritableByteChannel() {
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

