/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.monitoring.v3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.PathTemplate;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.ValidationException;
import net.snowflake.client.jdbc.internal.google.api.resourcenames.ResourceName;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;

public class TimeSeriesName
implements ResourceName {
    private static final PathTemplate PROJECT_TIME_SERIES = PathTemplate.createWithoutUrlEncoding("projects/{project}/timeSeries/{time_series}");
    private static final PathTemplate ORGANIZATION_TIME_SERIES = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/timeSeries/{time_series}");
    private static final PathTemplate FOLDER_TIME_SERIES = PathTemplate.createWithoutUrlEncoding("folders/{folder}/timeSeries/{time_series}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String timeSeries;
    private final String organization;
    private final String folder;

    @Deprecated
    protected TimeSeriesName() {
        this.project = null;
        this.timeSeries = null;
        this.organization = null;
        this.folder = null;
    }

    private TimeSeriesName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.timeSeries = Preconditions.checkNotNull(builder.getTimeSeries());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_TIME_SERIES;
    }

    private TimeSeriesName(OrganizationTimeSeriesBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.timeSeries = Preconditions.checkNotNull(builder.getTimeSeries());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_TIME_SERIES;
    }

    private TimeSeriesName(FolderTimeSeriesBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.timeSeries = Preconditions.checkNotNull(builder.getTimeSeries());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_TIME_SERIES;
    }

    public String getProject() {
        return this.project;
    }

    public String getTimeSeries() {
        return this.timeSeries;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectTimeSeriesBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationTimeSeriesBuilder newOrganizationTimeSeriesBuilder() {
        return new OrganizationTimeSeriesBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderTimeSeriesBuilder newFolderTimeSeriesBuilder() {
        return new FolderTimeSeriesBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TimeSeriesName of(String project, String timeSeries) {
        return TimeSeriesName.newBuilder().setProject(project).setTimeSeries(timeSeries).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TimeSeriesName ofProjectTimeSeriesName(String project, String timeSeries) {
        return TimeSeriesName.newBuilder().setProject(project).setTimeSeries(timeSeries).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TimeSeriesName ofOrganizationTimeSeriesName(String organization, String timeSeries) {
        return TimeSeriesName.newOrganizationTimeSeriesBuilder().setOrganization(organization).setTimeSeries(timeSeries).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TimeSeriesName ofFolderTimeSeriesName(String folder, String timeSeries) {
        return TimeSeriesName.newFolderTimeSeriesBuilder().setFolder(folder).setTimeSeries(timeSeries).build();
    }

    public static String format(String project, String timeSeries) {
        return TimeSeriesName.newBuilder().setProject(project).setTimeSeries(timeSeries).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectTimeSeriesName(String project, String timeSeries) {
        return TimeSeriesName.newBuilder().setProject(project).setTimeSeries(timeSeries).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationTimeSeriesName(String organization, String timeSeries) {
        return TimeSeriesName.newOrganizationTimeSeriesBuilder().setOrganization(organization).setTimeSeries(timeSeries).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderTimeSeriesName(String folder, String timeSeries) {
        return TimeSeriesName.newFolderTimeSeriesBuilder().setFolder(folder).setTimeSeries(timeSeries).build().toString();
    }

    public static TimeSeriesName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TIME_SERIES.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_TIME_SERIES.match(formattedString);
            return TimeSeriesName.ofProjectTimeSeriesName(matchMap.get("project"), matchMap.get("time_series"));
        }
        if (ORGANIZATION_TIME_SERIES.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_TIME_SERIES.match(formattedString);
            return TimeSeriesName.ofOrganizationTimeSeriesName(matchMap.get("organization"), matchMap.get("time_series"));
        }
        if (FOLDER_TIME_SERIES.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_TIME_SERIES.match(formattedString);
            return TimeSeriesName.ofFolderTimeSeriesName(matchMap.get("folder"), matchMap.get("time_series"));
        }
        throw new ValidationException("TimeSeriesName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<TimeSeriesName> parseList(List<String> formattedStrings) {
        ArrayList<TimeSeriesName> list = new ArrayList<TimeSeriesName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TimeSeriesName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TimeSeriesName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TimeSeriesName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TIME_SERIES.matches(formattedString) || ORGANIZATION_TIME_SERIES.matches(formattedString) || FOLDER_TIME_SERIES.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TimeSeriesName timeSeriesName = this;
            synchronized (timeSeriesName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.timeSeries != null) {
                        fieldMapBuilder.put("time_series", this.timeSeries);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TimeSeriesName that = (TimeSeriesName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.timeSeries, that.timeSeries) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.timeSeries);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderTimeSeriesBuilder {
        private String folder;
        private String timeSeries;

        protected FolderTimeSeriesBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getTimeSeries() {
            return this.timeSeries;
        }

        public FolderTimeSeriesBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderTimeSeriesBuilder setTimeSeries(String timeSeries) {
            this.timeSeries = timeSeries;
            return this;
        }

        public TimeSeriesName build() {
            return new TimeSeriesName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationTimeSeriesBuilder {
        private String organization;
        private String timeSeries;

        protected OrganizationTimeSeriesBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getTimeSeries() {
            return this.timeSeries;
        }

        public OrganizationTimeSeriesBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationTimeSeriesBuilder setTimeSeries(String timeSeries) {
            this.timeSeries = timeSeries;
            return this;
        }

        public TimeSeriesName build() {
            return new TimeSeriesName(this);
        }
    }

    public static class Builder {
        private String project;
        private String timeSeries;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTimeSeries() {
            return this.timeSeries;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTimeSeries(String timeSeries) {
            this.timeSeries = timeSeries;
            return this;
        }

        private Builder(TimeSeriesName timeSeriesName) {
            Preconditions.checkArgument(Objects.equals(timeSeriesName.pathTemplate, PROJECT_TIME_SERIES), "toBuilder is only supported when TimeSeriesName has the pattern of projects/{project}/timeSeries/{time_series}");
            this.project = timeSeriesName.project;
            this.timeSeries = timeSeriesName.timeSeries;
        }

        public TimeSeriesName build() {
            return new TimeSeriesName(this);
        }
    }
}

