/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.log.CommonsLoggingWrapper;
import net.snowflake.client.log.CommonsLoggingWrapperMode;
import net.snowflake.client.log.SFLoggerFactory;

public class SFLoggerUtil {
    private static final String NOT_PROVIDED_LOG = "not provided";
    private static final String PROVIDED_LOG = "provided";

    public static void initializeSnowflakeLogger() {
        CommonsLoggingWrapperMode commonsLoggingWrapperMode;
        String logger = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.loggerImpl");
        SFLoggerFactory.LoggerImpl loggerImplementation = SFLoggerFactory.LoggerImpl.fromString(logger);
        if (loggerImplementation == null) {
            loggerImplementation = SFLoggerFactory.LoggerImpl.JDK14LOGGER;
        }
        if ((commonsLoggingWrapperMode = CommonsLoggingWrapperMode.detect()) == CommonsLoggingWrapperMode.OFF) {
            return;
        }
        System.setProperty("net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory", "net.snowflake.client.jdbc.internal.apache.commons.logging.impl.LogFactoryImpl");
        LogFactory logFactory = LogFactory.getFactory();
        if (commonsLoggingWrapperMode == CommonsLoggingWrapperMode.ALL) {
            logFactory.setAttribute("net.snowflake.client.jdbc.internal.apache.commons.logging.Log", CommonsLoggingWrapper.class.getName());
            return;
        }
        switch (loggerImplementation) {
            case SLF4JLOGGER: {
                logFactory.setAttribute("net.snowflake.client.jdbc.internal.apache.commons.logging.Log", "net.snowflake.client.log.SLF4JJCLWrapper");
                break;
            }
            default: {
                logFactory.setAttribute("net.snowflake.client.jdbc.internal.apache.commons.logging.Log", "net.snowflake.client.log.JDK14JCLWrapper");
            }
        }
    }

    @SnowflakeJdbcInternalApi
    public static <T> String isVariableProvided(T variable) {
        if (variable instanceof String) {
            return SnowflakeUtil.isNullOrEmpty((String)variable) ? NOT_PROVIDED_LOG : PROVIDED_LOG;
        }
        return variable == null ? NOT_PROVIDED_LOG : PROVIDED_LOG;
    }
}

